<?php $__env->startSection('title','Registro de Datos'); ?>
<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="page-block">
        <div class="col-md-12">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="page-header-title">
                        <h5 class="m-b-10">REGISTRO DE <?php echo e($parTipoformulario->nombre); ?></h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Inicio</a></li>
                        <li class="breadcrumb-item">REGISTRO DE <?php echo e($parTipoformulario->nombre); ?></li>
                    </ul>
                </div>
                
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <?php
                $idFormulario = $parTipoformulario->idpar_tipoformulario;
                $puedeEditar = auth()->user()->can('editar_formulario_' . $idFormulario);
                $puedeEliminar = auth()->user()->can('eliminar_formulario_' . $idFormulario);
                
            ?>
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    <h4>LISTADO DE REGISTROS DE <?php echo e($parTipoformulario->nombre); ?></h4>
                        
                    <div>
                        <a href="<?php echo e(route('planillas.show',$parTipoformulario->slug)); ?>" target="_blank" class="btn btn-secondary">PREVISUALIZAR FORMULARIO</a>
                        <?php if(count($registros) > 0): ?>
                        <a class="btn btn-success btn-icon" href="<?php echo e(route('reportes.excel')); ?>" onclick="event.preventDefault(); document.getElementById('exportar_excel').submit();" title="Exportar a Excel">
                            <i class="fas fa-file-excel"></i> Exportar a XLS
                        </a>
                        <?php endif; ?>
                        
                    </div>
                </div>
            </div>
            <form id="exportar_excel" action="<?php echo e(route('reportes.excel')); ?>" method="POST" style="display: none;">
                <?php echo csrf_field(); ?>
                <?php echo e(Form::hidden('parTipoformulario', $parTipoformulario->idpar_tipoformulario)); ?>

                <?php echo e(Form::hidden('registros', base64_encode(serialize($registros)))); ?>

                <?php echo e(Form::hidden('secciones', base64_encode(serialize($secciones)))); ?>

            </form>
            
            <div class="card-body">
                <div class="table-responsive">
                    <p>Los datos de orden por fecha de orden descendente.</p>
                    <table class="table table-hover table-sm" id="scroll-fill">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">Fecha Registro</th>
                                <?php $__currentLoopData = $secciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($sec->tipo != 'tabla'): ?>
                                        <th class="text-center"><?php echo e($sec->item); ?></th>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                <th class="text-center">Nombres</th>
                                <th class="text-center">Cargo</th>
                                <th class="text-center">Unidad</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $registros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $registro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center justify-content-center">
                                            <a href="<?php echo e(route('planilla.pdf', $registro['idrep_formularioplanilladato'])); ?>" 
                                                    class="pl-2 pr-2 mr-2" 
                                                    title="Imprimir planilla" target="_blank">
                                                    <i class="fas fa-file"></i>
                                                </a>
                                            <?php if($puedeEditar): ?>
                                                <a href="<?php echo e(route('planilla_datos.edit', [$idFormulario, $registro['idrep_formularioplanilladato']])); ?>"
                                                    class="pl-2 pr-2 mr-2"
                                                    title="Modificar Registro">
                                                    <i class="fas fa-pen"></i>
                                                </a>
                                            <?php endif; ?>
                                    
                                            <?php if($puedeEliminar): ?>
                                                
                                                
                                                    
                                                    <?php echo Form::open(['route'=>['planilla_datos.destroy',$registro['idrep_formularioplanilladato']],'method'=>'DELETE']); ?>

                                                    <button class="btn mr-2 text-danger pl-2 pr-2"  title="Eliminar Registro" onclick="return confirm('�Esta seguro que desea eliminar el Registro?');"><i class="fas fa-trash"></i></button>
                                                <?php echo Form::close(); ?>

                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td class="text-center"><?php echo e(date('d/m/Y H:m',strtotime($registro['fecha_registro_formulario']))); ?></td>
                                    <?php $__currentLoopData = $secciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($sec->tipo != 'tabla'): ?>
                                            <?php if(isset($registro['valores'][$sec->cont])): ?>
                                            <td class="text-center" style="white-space: normal; word-wrap: break-word;">
                                                
                                                <?php switch($registro['tipos'][$sec->cont] ):
                                                    case ('date'): ?>
                                                        <?php echo e(date('d/m/Y',strtotime($registro['valores'][$sec->cont])) ?? '-'); ?>

                                                        <?php break; ?>
                                                    <?php case ('datetime'): ?>
                                                        <?php echo e(date('d/m/Y H:m',strtotime($registro['valores'][$sec->cont])) ?? '-'); ?>

                                                        <?php break; ?>
                                                    <?php case ('text_area'): ?>
                                                        ....
                                                        <?php break; ?>
                                                    <?php case ('cargar_documento'): ?>
                                                        <a href="<?php echo e(asset('adjuntos/'.$registro['valores'][$sec->cont])); ?>" target="_blank"> Ver Adjunto</a>
                                                    <?php default: ?>
                                                        <?php echo e($registro['valores'][$sec->cont] ?? '-'); ?>

                                                        <?php break; ?>
                                                <?php endswitch; ?>
                                            </td>
                                            <?php else: ?>
                                                <td>-</td>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                    <td class="text-center"><?php echo e($registro['cargo']); ?></td>
                                    <td class="text-center"><?php echo e($registro['unidad']); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<form id="delete-form" method="POST" style="display:none;">
    <?php echo csrf_field(); ?>
    <?php echo method_field('DELETE'); ?>
</form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/tablas/scroll.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/formularios_externos/resources/views/registro/index.blade.php ENDPATH**/ ?>