<?php $__env->startSection('title','Usuarios'); ?>
<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-12">
                <div class="page-header-title">
                    <h5>Usuarios</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><i class="feather icon-home"></i></a></li>
                    <li class="breadcrumb-item"><a href="#!">Configuración</a></li>
                    <li class="breadcrumb-item"><a href="#!">Listado de usuarios</a></li>
                </ul>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    <h5>Listado de Usuarios</h5>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.create')): ?><a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary btn-round mr-2">Agregar Nuevo</a><?php endif; ?>
                </div>
            </div>
            <div class="card-body table-border-style">
                <div class="table-responsive">
                    <table width="100%" id="datos" class="table table-hover table-sm">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">Nombre Completo</th>
                                <th class="text-center">Nombre de Usuario</th>
                                <th class="text-center">Correo</th>
                                <th class="text-center">Rol Asignado</th>
                                <th class="text-center">Unidad RRHH</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center justify-content-center">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.edit')): ?>
                                                    <button class="btn"><a href="<?php echo e(route('users.edit',$user->id)); ?>" title="Modificar datos"><i class="fas fa-edit"></i></a></button>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.destroy')): ?>
                                                    <button class="btn "><a href="<?php echo e(route('users.destroy',$user->id)); ?>"  title="Eliminar Registro" onclick="return confirm('¿Está seguro que desea eliminar al USUARIO?');"><i class="fas fa-trash-alt text-danger"></i></a></button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                        <td>
                                            <?php echo e($user->name); ?> <br>
                                            <strong><?php echo e($user->cargo); ?></strong>
                                        </td>
                                        <td class="text-center"><?php echo e($user->username); ?></td>
                                        <td class="text-center"><?php echo e($user->email); ?></td>
                                        <td class="text-center">
                                            <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <strong><?php echo e($rol->name); ?></strong>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>
                                        <td class="text-center"><?php if($user->unidad_rrhh != null ): ?><?php echo e($user->unidad_rrhh); ?> <?php endif; ?></td>
                                        
                                    </tr>
                                
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
 <script src="<?php echo e(asset('assets/js/tablas/basica.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/formularios_externos/resources/views/admin/users/index.blade.php ENDPATH**/ ?>