<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RepFormularioplanilladatoController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Auth::routes();
// Route::get('sso-login', [App\Http\Controllers\SsoAutenticacionSeguridadController::class, 'autenticacion']);

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/create',[App\Http\Controllers\RepFormularioplanilladatoController::class,'create'])->name('planillas.create');
Route::post('guardar',[App\Http\Controllers\RepFormularioplanilladatoController::class,'store'])->name('planillas.store');
Route::get('/refresh-captcha', [App\Http\Controllers\Auth\LoginController::class, 'refreshCaptcha']);
Route::get('/reportes/coordenadas_epps', [App\Http\Controllers\HomeController::class, 'coordenadas'])->name('coordenadas.index');
//Acceso a la vista de inscripcion registrada
Route::prefix('process')->group(function () {
    Route::get('registro/{slug}', [App\Http\Controllers\RepFormularioplanilladatoController::class, 'formulario_registrado'])->name('formulario_registrado.index');
    Route::get('finalizada/{slug}', [App\Http\Controllers\RepFormularioplanilladatoController::class, 'formulario_finalizado'])->name('formulario_finalizado.index');
    // Otras rutas internas...
});
/*Route::prefix('reportes')->group(function () {
    Route::get('coordenadas_epps', [App\Http\Controllers\HomeController::class, 'coordenadas'])->name('coordenadas.index');
});*/

Route::get('/{slug}', [App\Http\Controllers\RepFormularioplanilladatoController::class, 'publicar_formulario'])->name('publicar_formulario.index');

Route::middleware(['auth'])->prefix('admin')->group(function(){
    //Roles
    Route::post('roles/store',[App\Http\Controllers\RoleController::class,'store'])->name('roles.store')->middleware('permission:roles.create');
    Route::get('roles',[App\Http\Controllers\RoleController::class,'index'])->name('roles.index')->middleware('permission:roles.index');
    Route::get('roles/create',[App\Http\Controllers\RoleController::class,'create'])->name('roles.create')->middleware('permission:roles.create');
    Route::put('roles/{role}',[App\Http\Controllers\RoleController::class,'update'])->name('roles.update')->middleware('permission:roles.edit');
    Route::get('roles/{role}',[App\Http\Controllers\RoleController::class,'show'])->name('roles.show')->middleware('permission:roles.show');
    Route::delete('roles/{role}',[App\Http\Controllers\RoleController::class,'destroy'])->name('roles.destroy')->middleware('permission:roles.destroy');
    Route::get('roles/{role}/edit',[App\Http\Controllers\RoleController::class,'edit'])->name('roles.edit')->middleware('permission:roles.edit');
    
    //Userd
    Route::post('users/store',[App\Http\Controllers\UserController::class,'store'])->name('users.store')->middleware('permission:users.create');
    Route::get('users',[App\Http\Controllers\UserController::class,'index'])->name('users.index')->middleware('permission:users.index');
    Route::get('users/create',[App\Http\Controllers\UserController::class,'create'])->name('users.create')->middleware('permission:users.create');
    Route::put('users/{user}',[App\Http\Controllers\UserController::class,'update'])->name('users.update')->middleware('permission:users.edit');
    Route::get('users/{user}/eliminar',[App\Http\Controllers\UserController::class,'destroy'])->name('users.destroy')->middleware('permission:users.destroy');
    Route::get('users/{user}/edit',[App\Http\Controllers\UserController::class,'edit'])->name('users.edit')->middleware('permission:users.edit');
    Route::get('datos_empleado',[App\Http\Controllers\UserController::class,'datos_empleado'])->name('datos_empleado')->middleware('permission:users.create');
    //Campos
    Route::post('items_update', [App\Http\Controllers\ParItemController::class, 'update'])->name('items.update')->middleware('permission:items.edit');
    Route::get('items', [App\Http\Controllers\ParItemController::class, 'index'])->name('items.index')->middleware('permission:items.index');
    Route::get('listar_items', [App\Http\Controllers\ParItemController::class, 'listar_items'])->name('listar_items.index')->middleware('permission:items.index');
    Route::delete('eliminar_campo/{id}', [App\Http\Controllers\ParItemController::class, 'destroy'])->name('items.destroy')->middleware('permission:items.destroy');

//Tipo Formulario
    Route::post('tipo_formulario/store', [App\Http\Controllers\ParTipoformularioController::class, 'store'])->name('tipo_formulario.store')->middleware('permission:tipo_formulario.create');
    Route::get('tipo_formulario', [App\Http\Controllers\ParTipoformularioController::class, 'index'])->name('tipo_formulario.index')->middleware('permission:tipo_formulario.index');
    Route::get('tipo_formulario/create',[App\Http\Controllers\ParTipoformularioController::class,'create'])->name('tipo_formulario.create')->middleware('permission:tipo_formulario.create');
    Route::put('tipo_formulario/{parTipoformulario}',[App\Http\Controllers\ParTipoformularioController::class,'update'])->name('tipo_formulario.update')->middleware('permission:tipo_formulario.edit');
    Route::get('tipo_formulario/{parTipoformulario}/edit',[App\Http\Controllers\ParTipoformularioController::class,'edit'])->name('tipo_formulario.edit')->middleware('permission:tipo_formulario.edit');
    Route::delete('tipo_formulario/{parTipoformulario}/destroy', [App\Http\Controllers\ParTipoformularioController::class, 'destroy'])->name('tipo_formulario.destroy')->middleware('permission:tipo_formulario.destroy');
    Route::post('cambiar_estado_formulario', [App\Http\Controllers\ParTipoformularioController::class, 'cambiar_estado'])->name('tipo_formulario.estado')->middleware('permission:tipo_formulario.create');

    //Empresa
    Route::post('empresa/store', [App\Http\Controllers\ParEmpresaController::class, 'store'])->name('empresa.store')->middleware('permission:empresa.create');
    Route::get('empresa', [App\Http\Controllers\ParEmpresaController::class, 'index'])->name('empresa.index')->middleware('permission:empresa.index');
    Route::get('empresa/{id}/edit', [App\Http\Controllers\ParEmpresaController::class, 'edit'])->name('empresa.edit')->middleware('permission:empresa.edit');
    Route::post('empresa/{id}', [App\Http\Controllers\ParEmpresaController::class, 'update'])->name('empresa.update')->middleware('permission:empresa.edit');
    Route::delete('empresa/{id}', [App\Http\Controllers\ParEmpresaController::class, 'destroy'])->name('empresa.destroy')->middleware('permission:empresa.destroy');

    //Unidad de Medida
    Route::get('unidad_medida', [App\Http\Controllers\ParUnidadmedidaController::class, 'index'])->name('unidad_medida.index')->middleware('permission:unidades.index');
    Route::get('listar_unidades', [App\Http\Controllers\ParUnidadmedidaController::class, 'listar_unidades'])->name('listar_unidades.index')->middleware('permission:unidades.index');
    Route::post('unidad_medida/store', [App\Http\Controllers\ParUnidadmedidaController::class, 'store'])->name('unidad_medida.store')->middleware('permission:unidades.create');
    Route::delete('unidad_medida/{id}/destroy', [App\Http\Controllers\ParUnidadmedidaController::class, 'destroy'])->name('unidad_medida.destroy')->middleware('permission:unidades.destroy');
    
    //RUTAS PARA CREAR LOS FORMULARIOS
    Route::get('crear_formulario/{activo_id?}',[App\Http\Controllers\RepFormularioseccionController::class,'index'])->name('formularios.index')->middleware('permission:tipo_formulario.index');
    
    Route::get('secciones_formulario/{repFormularioseccion}/edit',[App\Http\Controllers\RepFormularioseccionController::class,'edit'])->name('secciones.edit')->middleware('permission:tipo_formulario.index');
    Route::get('secciones_formulario',[App\Http\Controllers\RepFormularioseccionController::class,'listar_secciones'])->name('secciones.listar')->middleware('permission:tipo_formulario.index');
    Route::get('secciones_items',[App\Http\Controllers\RepFormularioseccionController::class,'items'])->name('secciones.items')->middleware('permission:tipo_formulario.index');
    Route::post('secciones/store',[App\Http\Controllers\RepFormularioseccionController::class,'store'])->name('secciones.store')->middleware('permission:tipo_formulario.store');
    Route::delete('secciones/{repFormularioseccion}',[App\Http\Controllers\RepFormularioseccionController::class,'destroy'])->name('secciones.destroy')->middleware('permission:tipo_formulario.destroy'); 
    
    //items desde secciones 

    Route::post('item/store',[App\Http\Controllers\RepFormularioseccionController::class,'item_store'])->name('seccion_item.store')->middleware('permission:tipo_formulario.store');
    Route::post('item_calculo/store',[App\Http\Controllers\RepFormularioseccionController::class,'item_calculo_store'])->name('seccion_item_calculo.store')->middleware('permission:tipo_formulario.store');
    Route::delete('contenido/{repFormulariocontenido}',[App\Http\Controllers\RepFormulariocontenidoController::class,'destroy'])->name('campo.destroy')->middleware('permission:tipo_formulario.destroy');
    
    //RUTAS PARA LLENAR LAS PLANILLAS
    //ingreso a la vista de registro de datos de la planilla
    Route::get('formulario/{parTipoformulario}',[RepFormularioplanilladatoController::class,'index'])->name('planillas.index')->middleware('check.formulario:ver');
    Route::get('planillas/{parTipoformulario}/{repFormularioplanilladato}/edit',[App\Http\Controllers\RepFormularioplanilladatoController::class,'edit'])->name('planilla_datos.edit')->middleware('check.formulario:editar');
    Route::put('planilla/{repFormularioplanilladato}',[App\Http\Controllers\RepFormularioplanilladatoController::class,'update'])->name('planilla_datos.update')->middleware('check.formulario:editar');
    Route::delete('planilla/{repFormularioplanilladato}',[App\Http\Controllers\RepFormularioplanilladatoController::class,'destroy'])->name('planilla_datos.destroy');
    Route::get('previsualizar/{parTipoformulario}', [App\Http\Controllers\RepFormularioplanilladatoController::class, 'show'])->name('planillas.show')->middleware('check.formulario:ver');
    
    //REPORTES
    Route::post('registros_excel',[App\Http\Controllers\RepFormularioplanilladatoController::class,'exportar_excel'])->name('reportes.excel');
    Route::get('planilla_pdf/{repFormularioplanilladato}', [App\Http\Controllers\RepFormularioplanilladatoController::class, 'exportar_pdf'])->name('planilla.pdf');
     Route::get('ver_adjuntos/{adjunto}',[App\Http\Controllers\RepFormularioplanilladatoController::class,'ver_adjuntos'])->name('ver_adjuntos');

    //RUTAS PARA LLENAR LAS PLANILLAS CON TABLAS
    Route::get('registros_planilla_tabla/{repFormularioplanilladato}/{repFormularioseccion}',[App\Http\Controllers\RepFormularioplanilladatoController::class,'create_tabla'])->name('registros.tabla');
    Route::get('editar_registros_planilla_tabla/{repFormularioplanilladato}/{repFormularioseccion}',[App\Http\Controllers\RepFormularioplanilladatoController::class,'edit_tabla'])->name('registros_edit.tabla');
    Route::post('guardar_registros',[App\Http\Controllers\RepFormularioplanilladatoController::class,'store_tabla'])->name('planillas_tabla.store');
    Route::delete('eliminar_registro/{repFormularioplanilladato}/{nro_item}/{repFormularioseccion}', [App\Http\Controllers\RepFormularioplanilladatoController::class, 'destroy_registro'])->name('registro.destroy');
    Route::get('registros_planilla_aprobar/{repFormularioplanilladato}/{estado}',[App\Http\Controllers\RepFormularioplanilladatoController::class,'aprobar'])->name('planilla_datos.aprobar');
    //combo listas campos pertenecen a seccion
    Route::get('obtener_campos_seccion', [App\Http\Controllers\RepFormularioseccionController::class, 'campos_seccion'])->name('campos.seccion');

    //RUTAS PARA CREAR LOS FORMULARIOS
    Route::get('generar_permisos',[App\Http\Controllers\PerfilPermisoController::class,'seedPermisosDesdeFormularios'])->name('permisos.formularios');
    Route::get('perfiles-permisos', [App\Http\Controllers\PerfilPermisoController::class, 'index'])->name('perfil.permisos.index');
    Route::post('perfiles-permisos/guardar', [App\Http\Controllers\PerfilPermisoController::class, 'guardar'])->name('perfil.permisos.guardar');
    Route::get('perfiles-permisos/obtener', [App\Http\Controllers\PerfilPermisoController::class, 'obtenerPermisos'])->name('perfil.permisos.obtener');
    Route::get('permisos_formulario', [App\Http\Controllers\PerfilPermisoController::class, 'obtenerPermisosPorRol'])->name('perfiles-permisos.obtener-permisos');
});
Route::get('/', function () {
    return view('auth.login');
})->name('inicio');