@extends('layouts.app')
@section('title','Tipo de Formulario')
@section('content')
<div class="page-header">
  <div class="page-block">
      <div class="row align-items-center">
          <div class="col-md-6">
              <div class="page-header-title">
                  <h5 class="m-b-10">TIPOS DE FORMULARIO</h5>
              </div>
              <ul class="breadcrumb">
                  <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
                  <li class="breadcrumb-item">Tipo de Formulario</li>
              </ul>
          </div>
      </div>
  </div>
</div>
      <!-- [ Main Content ] start -->
      <div class="row">
        <!-- [ sample-page ] start -->
        <div class="col-sm-12">
          <div class="card">
            <div class="card-header">
              <div class="d-flex align-items-center justify-content-between">
                <h4>Tipos de formularios registrados</h4>
                @can('tipo_formulario.create')
                  <a href="{{ route('tipo_formulario.create') }}" class="btn btn-primary" onclick="create();">Nuevo Formulario</a>
                @endcan
              </div>
            </div>
            <div class="card-body"> 
                <div class="table-responsive">
                    <table class="table table-inverse table-sm" id="datos" style="width: 100%;">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">Tipo</th>
                                <th class="text-center">Estado </th>
                                <th class="text-center">Fecha inicio publicación </th>
                                <th class="text-center">Fecha fin publicación </th>
                                <th class="text-center">URL</th>
                                <th class="text-center">Nombre formulario</th>
                                <th class="text-center">Descripción formulario</th>
                                <th class="text-center">Descripción aclarando campo obligatorio </th>
                                <th class="text-center">Mensaje formulario llenado </th>
                                <th class="text-center">Mensaje formulario deshabilitado </th>
                                <th class="text-center">Código</th>
                                <th class="text-center">Formato <br>Impresion</th>
                                <th class="text-center">Logo</th>
                                <th class="text-center">Fondo </th>
                                <th class="text-center">Color Fondo </th>
                                <th class="text-center">Color Texto Campos </th>
                                <th class="text-center">Color Titulo </th>
                                <th class="text-center">Color Subtitulo </th>
                            </tr>
                        </thead>
                        <tbody>
                          @foreach ($tipos_formulario as  $tipo)
                            <tr>
                              <td class="d-flex flex-column align-items-center justify-content-center">
                                @can('tipo_formulario.edit')
                                  <a href="{{ route('tipo_formulario.edit', $tipo->idpar_tipoformulario) }}" class="m-1" title="Modificar datos tipo formulario" ><i class="fa fa-edit"></i></a>
                                @endcan
                                @can('tipo_formulario.destroy')
                                  <a href="javascript:void(0)" type="button" class="btnDelete text-danger m-1" data-id="' + fila.idpar_tipoformulario + '" data-name="'+fila.nombre+'" title="Eliminar tipo formulario"><i class="fa fa-trash"></i></a>
                                @endcan
                                @can('tipo_formulario.create')
                                  <a href="javascript:void(0)" type="button" class="btnPublicar m-1 text-success"  data-id="{{ $tipo->idpar_tipoformulario }}" data-estado="{{ $tipo->estado }}"  title="Publicar tipo formulario" ><i class="fas fa-cloud-upload-alt"></i></a>
                                @endcan
                              </td>
                              <td>{{ $tipo->tipo }}</td>
                              <td> @if($tipo->estado == 1) <span class="badge badge-success">Publicado</span> @else <span class="badge badge-danger">No publicado</span> @endif</td>
                              <td>{{ $tipo->fecha_inicio }}</td>
                              <td>{{ $tipo->fecha_fin }}</td>
                              <td>{{ $tipo->slug }}</td>
                              <td>{{ $tipo->nombre }}</td>
                              <td>{{ $tipo->descripcion }}</td>
                              <td>{{ $tipo->descripcion_campo_obligatorio }}</td>
                              <td>{{ $tipo->mensaje_de_llenado_formulario }}</td>
                              <td>{{ $tipo->mensaje_de_formulario_deshabilitado }}</td>
                              <td>{{ $tipo->codigo }}</td>
                              <td>{{ $tipo->formato_impresion }}</td>
                              <td> <img src="{{ asset('img/' . $tipo->logo) }}" alt="" style="width:100px;"></td>
                              <td> <img src="{{ asset('img/' . $tipo->fondo) }}" alt="" style="width:100px;"> </td>
                              <td style="background-color: {{ $tipo->color_fondo }};" >{{ $tipo->color_fondo }}</td>
                              <td style="background-color: {{ $tipo->color_texto }};"> {{ $tipo->color_texto }}</td>
                              <td style="background-color: {{ $tipo->color_titulo }};" >{{ $tipo->color_titulo }}</td>
                              <td style="background-color: {{ $tipo->color_subtitulo }};">{{ $tipo->color_subtitulo }}</td>
                            </tr>
                          @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
          </div>
        </div>
        <!-- [ sample-page ] end -->
      </div>
      <!-- [ Main Content ] end -->
    </div>
  </div>
@include('tipo_formulario._modal')
@include('tipo_formulario._estado')
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/moment.min.js"></script>
    <script src="{{ asset('assets/js/pages/crudTipoFormulario.js') }}"></script>
    <script src="{{ asset('assets/js/pages/estadoTipoFormulario.js') }}"></script>
@endsection
