<div class="modal" id="modalSeccion" >
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" aria-hidden="true">
                    <i class="fa fa-times"></i>
                </button>
            </div>
            <form action="{{ route('secciones.store') }}" method="POST">
                @csrf
                <input type="hidden" name="idrep_formularioseccion" id="idrep_formularioseccion">
                <div class="modal-body">
                    <p>Debe rellenar todos los campos.</p>
                    @if ($errors->any())
                        <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                        <ul class="list-ticked mensaje-error">
                            @foreach ($errors->all() as $error)
                                <li class="text-danger">{{ $error }}</li>
                            @endforeach
                        </ul>
                    @endif
                    <div class="row form-group mb-2">
                        <label for="nombre" class="col-md-4 col-form-label text-md-right">Tipo Formulario: <span class="text-danger">(*)</span></label>
                        <div class="col-md-6">
                            <select name="idpar_tipoformulario" id="idpar_tipoformulario" class="form-control @error('idpar_tipoformulario') is-invalid @enderror" required>
                                <option value="">--SELECCIONE--</option>
                                @foreach ($tipo_formulario as $tipo)
                                    <option value="{{ $tipo->idpar_tipoformulario }}">{{ $tipo->nombre }}</option>
                                @endforeach
                            </select>
                            @error('idpar_tipoformulario')
                                <span class="invalid-feedback" role="alert">                        
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="row form-group mb-2">
                        <label for="nombre" class="col-md-4 col-form-label text-md-right">Nombre Sección: <span class="text-danger">(*)</span></label>
                        <div class="col-md-8">
                            <input id="nombre_seccion" type="text" class="form-control @error('nombre') is-invalid @enderror" name="nombre" value="{{ old('nombre') }}" required autofocus>
                            @error('nombre')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="row form-group mb-2">
                        <label for="orden" class="col-md-4 col-form-label text-md-right">Posición: <span class="text-danger">(*)</span></label>
                        <div class="col-md-2">
                            <input id="orden" type="number" class="form-control @error('orden') is-invalid @enderror" name="orden" value="{{ old('orden') }}"  >
                            @error('orden')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="row form-group mb-2">
                        <label for="tipo" class="col-md-4 col-form-label text-md-right">Tipo Sección: <span class="text-danger">(*)</span></label>
                        <div class="col-md-6">
                            <select name="tipo" id="tipo" class="form-control @error('tipo') is-invalid @enderror" required>
                                <option value="">--SELECCIONE--</option>
                                <option value="general">Datos Generales</option>
                                <option value="tabla">Tabla de registros</option>
                            </select>
                            @error('tipo')
                                <span class="invalid-feedback" role="alert">                        
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary">Guardar</button>
                    <button type="button" class="btn btn-warning" data-dismiss="modal">Salir</button>
                </div>
            </form>
        </div>
    </div>
</div>
