<div class="modal" id="itemCalculoModal" >
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">CAMPO CON FORMULA DE CALCULO</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" aria-hidden="true">
                    <i class="fa fa-times"></i>
                </button>
            </div>
            <form action="{{ route('seccion_item_calculo.store') }}" method="POST">
                @csrf
                <input type="hidden" name="idsec_calculo" id="idsec_calculo">
                <input type="hidden" name="idcontenido_calculo" id="idcontenido_calculo" value="{{ old('id_contenido') }}">
                <input type="hidden" name="iditem_calculo" id="iditem_calculo" value="{{ old('id_item') }}">
                <div class="modal-body">
                    @if ($errors->errorItemCalculo->any())
                        <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                        <ul class="list-ticked mensaje-error">
                            @foreach ($errors->errorItemCalculo->all() as $error)
                                <li class="text-danger">{{ $error }}</li>
                            @endforeach
                        </ul>
                    @endif 
                    <div class="form-group row form-horizontal mb-1">
                        <label for="nombre" class="col-sm-12 col-md-3 text-md-right">Posición: <span class="text-danger">(*)</span></label>
                        <div class="col-sm-12 col-md-2">
                            <input type="number" name="ordenItem_calculo" id="ordenItem_calculo" class="form-control {{ $errors->errorItemCalculo->has('ordenItem_calculo') ? ' is-invalid' : '' }}" value="{{ old('ordenItem_calculo') }}">
                        </div>
                    </div>
                    <div class="form-group row form-horizontal mb-1">
                        <label for="nombre" class="col-sm-12 col-md-3 text-md-right">Nombre del Campo: <span class="text-danger">(*)</span></label>
                        <div class="col-sm-12 col-md-9">
                            <input type="text" name="nombreItem_calculo" id="nombreItem_calculo" class="form-control {{ $errors->errorItemCalculo->has('nombreItem_calculo') ? ' is-invalid' : '' }}" value="{{ old('nombreItem_calculo') }}">
                        </div>
                    </div>
                    <p>Debe seleccionar los campos que quiere utilizar y seleccionarlos a la vez que va conformando la formula requerida.</p>
                    <div class="form-group row form-horizontal mb-1">
                        <label for="campos" class="col-md-3 text-md-right" >Seleccionar Campos: <span class="text-danger">(*)</span></label>
                        <div class="col-md-9">
                            <select class="form-control" name="campos" id="campos" onchange="agregarCampo()"></select>
                            {{-- <button type="button" class="btn btn-primary" onclick="agregarCampo()">Agregar Campo</button> --}}
                        </div>
                    </div>
                    <div class="form-group row form-horizontal mb-1">
                        <label for="operador"  class="col-md-3 text-md-right">Operadores:</label>
                        <div class="col-md-9">
                            <button type="button" class="btn btn-primary" onclick="agregarOperador('+')">+</button>
                            <button type="button" class="btn btn-primary" onclick="agregarOperador('-')">-</button>
                            <button type="button" class="btn btn-primary" onclick="agregarOperador('*')">*</button>
                            <button type="button" class="btn btn-primary" onclick="agregarOperador('/')">/</button>
                            <button type="button" class="btn btn-primary" onclick="agregarOperador('(')">(</button>
                            <button type="button" class="btn btn-primary" onclick="agregarOperador(')')">)</button>
                        </div>
                    </div>
                    <div class="row form-group mb-2">
                        <label for="formula" class="col-md-3 col-form-label text-md-right">Fórmula: <span class="text-danger">(*)</span></label>
                        <div class="col-md-9">
                            <input id="formula" type="text" class="form-control {{ $errors->errorItemCalculo->has('formula') ? ' is-invalid' : '' }}" name="formula" value="{{ old('formula') }}">
                            @error('formula')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary">Guardar</button>
                    <button type="button" class="btn btn-warning" data-dismiss="modal">Salir</button>
                </div>
            </form>
        </div>
    </div>
</div>
