<div class="modal" id="modalItem" tabindex="-1" aria-labelledby="rechazoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title">CAMPOS DEL FORMULARIO</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close" aria-hidden="true" onclick="closeItemModal();">
                <i class="fa fa-times"></i>
            </button>
        </div>
        <form action="{{ route('seccion_item.store') }}" method="POST">
            @csrf
            <input type="hidden" name="id_contenido" id="id_contenido" value="{{ old('id_contenido') }}">
            <div class="modal-body">
                <p>Debe indicar la posición del campo dentro del formulario, puede ingresar el nombre del nuevo campo o utilizar la descripción de otro ya ingresado.</p>
                
                @if ($errors->errorItem->any())
                    <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                    <ul class="list-ticked mensaje-error">
                        @foreach ($errors->errorItem->all() as $error)
                            <li class="text-danger">{{ $error }}</li>
                        @endforeach
                    </ul>
                @endif 
                <div class="form-group row form-horizontal mb-2 mt-2">
                    <label for="obligatorio" class="col-md-3 text-md-right" >Ingreso Obligatorio?: <span class="text-danger">(*)</span></label>
                    <div class="col-md-9 ">
                        <div class="form-check form-check-inline ">
                            <input type="radio" name="obligatorio" class="form-check-input {{ $errors->errorItem->has('obligatorio') ? ' is-invalid' : '' }}" id="customCheckinl4" value="true" {{ old('obligatorio') == 'true' ? 'checked' : '' }}>
                            <label class="form-check-label" for="customCheckinl4">Si</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input type="radio" name="obligatorio" class="form-check-input {{ $errors->errorItem->has('obligatorio') ? ' is-invalid' : '' }}" id="customCheckinl5" value="false" {{ old('obligatorio') == 'false' ? 'checked' : '' }}>
                            <label class="form-check-label" for="customCheckinl5">No</label>
                        </div>
                    </div>
                </div>
                <div class="form-group row form-horizontal mb-2 mt-2">
                    <label for="unico" class="col-md-3 text-md-right" >Validar unico valor?: <span class="text-danger">(*)</span></label>
                    <div class="col-md-9 ">
                        <div class="form-check form-check-inline ">
                            <input type="radio" name="unico" class="form-check-input {{ $errors->errorItem->has('unico') ? ' is-invalid' : '' }}" id="customCheckinl4" value="true" {{ old('unico') == 'true' ? 'checked' : '' }}>
                            <label class="form-check-label" for="customCheckinl4">Si</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input type="radio" name="unico" class="form-check-input {{ $errors->errorItem->has('unico') ? ' is-invalid' : '' }}" id="customCheckinl5" value="false" {{ old('unico') == 'false' ? 'checked' : '' }}>
                            <label class="form-check-label" for="customCheckinl5">No</label>
                        </div>
                    </div>
                </div>
                <div class="form-group row form-horizontal mb-1">
                    <label for="nombre" class="col-sm-12 col-md-3 text-md-right">Posición: <span class="text-danger">(*)</span></label>
                    <div class="col-sm-12 col-md-2">
                        <input type="number" name="orden_item" id="orden_item" class="form-control {{ $errors->errorItem->has('orden_item') ? ' is-invalid' : '' }}" value="{{ old('orden_item') }}">
                    </div>
                </div>
         
                <div class="form-group row form-horizontal mb-1">
                    <label for="nombre" class="col-sm-12 col-md-3 text-md-right">Nombre del Campo:</label>
                    <div class="col-sm-12 col-md-9">
                        <input type="text" name="nombre_item" id="nombre_item" class="form-control {{ $errors->errorItem->has('nombre_item') ? ' is-invalid' : '' }}" value="{{ old('nombre_item') }}">
                    </div>
                </div>
                <div class="form-group row form-horizontal mb-1">
                    <label for="grupo_item" class="col-md-3 text-md-right" >Campo existente:</label>
                    <div class="col-md-9">
                        <select class="form-control" name="itemSelect" id="itemSelect">
                            <option value="">--BUSQUE Y SELECCIONE--</option>
                            @foreach ($items as $i)
                                <option value="{{ $i->idpar_item }}" {{ old('itemSelect')==$i->idpar_item }} >{{ $i->nombre }} ({{ $i->idpar_unidadmedida != NULL ? $i->unidad_medida->nombre : 'SD' }})</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-group row form-horizontal mb-1">
                    <label for="nombre" class="col-sm-12 col-md-3 text-md-right">Valor predeterminado:</label>
                    <div class="col-sm-12 col-md-9">
                        <textarea name="valor_predeterminado" id="valor_predeterminado" cols="30" rows="2" class="form-control {{ $errors->errorItem->has('valor_predeterminado') ? ' is-invalid' : '' }}">{{ old('valor_predeterminado') }}</textarea>
                    </div>
                </div>
                <div class="form-group row form-horizontal mb-1">
                    <label for="nombre" class="col-sm-12 col-md-3 text-md-right">Ancho (cm):</label>
                    <div class="col-sm-12 col-md-9">
                        <input type="number" class="form-control" name="ancho_campo" id="ancho_campo" value="{{ old('ancho_campo') }}">
                    </div>
                </div>
                <hr>
                <p>Debe especificar el tipo de campo, ya que al momento de registrar controlara su presentación en el formulario, si en el formulario el campo require especificar su unidad de medida puede seleccionar de las preregistradas.</p>
                <div class="form-group row form-horizontal mb-1">
                    <label for="tipo_campo" class="col-md-3 text-md-right" >Tipo Campo: <span class="text-danger">(*)</span></label>
                    <div class="col-md-9">
                        <select class="form-control  {{ $errors->errorItem->has('tipo_campo') ? ' is-invalid' : '' }}" name="tipo_campo" id="tipo_campo">
                            <option value="">--SELECCIONE--</option>
                            <option value="date" {{ old('tipo_campo') == 'date' ? 'selected' : '' }}>Fecha</option>
                            <option value="time" {{ old('tipo_campo') == 'time' ? 'selected' : '' }} >Hora</option>
                            <option value="datetime" {{ old('tipo_campo') == 'datetime' ? 'selected' : '' }} >Fecha y Hora</option>
                            <option value="text" {{ old('tipo_campo') == 'text' ? 'selected' : '' }}>Texto</option>
                            <option value="CI" {{ old('tipo_campo') == 'CI' ? 'selected' : '' }}>CI</option>
                            <option value="email" {{ old('tipo_campo') == 'email' ? 'selected' : '' }}>Correo</option>
                            <option value="text_area" {{ old('tipo_campo') == 'text_area' ? 'selected' : '' }}>Texto Largo</option>
                            <option value="number" {{ old('tipo_campo') == 'number' ? 'selected' : '' }} >Numérico entero</option>
                            <option value="decimal" {{ old('tipo_campo') == 'decimal' ? 'selected' : '' }} >Numérico con decimales</option>
                            <option value="select" {{ old('tipo_campo') == 'select' ? 'selected' : '' }} >Lista</option>
                            <option value="bolean" {{ old('tipo_campo') == 'bolean' ? 'selected' : '' }} >Opción de selección</option>
                            <option value="checkbox" {{ old('tipo_campo') == 'checkbox' ? 'selected' : '' }} >Opción para marcar</option>
                            <option value="correlativo" {{ old('tipo_campo') == 'correlativo' ? 'selected' : '' }} >Correlativo</option>
                            <option value="nombre" {{ old('tipo_campo') == 'nombre' ? 'selected' : '' }} >Nombre Persona</option>
                            <option value="cargo" {{ old('tipo_campo') == 'cargo' ? 'selected' : '' }} >Cargo Persona</option>
                            <option value="seleccion_multiple" {{ old('tipo_campo') == 'seleccion_multiple' ? 'selected' : '' }} >Seleccion multiple</option>
                            <option value="solo_numeros" {{ old('tipo_campo') == 'solo_numeros' ? 'selected' : '' }} >Campo de solo números</option>
                            <option value="parrafo" {{ old('tipo_campo') == 'label' ? 'selected' : '' }} >Parrafo o descripción (Llenar valor predeterminado)</option>
                            <option value="cargar_documento" {{ old('tipo_campo') == 'cargar_documento' ? 'selected' : '' }} >Subir Adjunto Tipo Word/Pdf</option>
                        </select>
                    </div>
                </div>
                <div id="seccionLista" style="display: none;">
                    <div class="form-group row form-horizontal mb-1">
                        <label for="nombre" class="col-sm-12 col-md-3 text-md-right">Contenido de la Lista: <p class="text-danger">Separe cada valor con punto y coma.</p></label> 
                        <div class="col-sm-12 col-md-9">
                            <input type="text" name="items_lista" id="items_lista" class="form-control {{ $errors->errorItem->has('items_lista') ? ' is-invalid' : '' }}" value="{{ old('items_lista') }}">
                        </div>
                    </div>
                </div>
                <div class="form-group row form-horizontal mb-1">
                    <label for="id_unidad_medida" class="col-md-3 text-md-right" >Unidad de Medida:</label>
                    <div class="col-md-9">
                        <select class="form-control" name="id_unidad_medida" id="id_unidad_medida">
                            <option value="">--SELECCIONE--</option>
                            @foreach ($unidades as $unidad)
                                <option value="{{ $unidad->idpar_unidadmedida }}" {{ old('id_unidad_medida')==$unidad->idpar_unidadmedida }}>{{ $unidad->simbolo }}-{{ $unidad->nombre }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <hr>
                <p>El campo que se agregue se puede agrupar con otro campo previamente registrado o agregar una variable como nuevo grupo</p>
                <div class="form-group row form-horizontal mb-1">
                    <label for="grupo_item" class="col-md-3 text-md-right" >Agrupar campo con:</label>
                    <div class="col-md-9">
                        <select class="form-control" name="grupo_item" id="grupo_item">
                            <option value="">--BUSQUE Y SELECCIONE--</option>
                            @foreach ($items as $item)
                                <option value="{{ $item->idpar_item }}" {{ old('grupo_item') == $item->idpar_item }}>{{ $item->nombre }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-group row form-horizontal mb-1">
                    <label for="nombre_grupo" class="col-sm-12 col-md-3 text-md-right">Nombre Grupo:</label>
                    <div class="col-sm-12 col-md-9">
                        <input type="text" name="nombre_grupo" id="nombre_grupo" class="form-control" value="{{ old('nombre_grupo') }}">
                    </div>
                </div>
               
                <input type="hidden" name="id_seccion" id="id_seccion" value="{{ old('id_seccion') }}">
                <input type="hidden" name="id_item" id="id_item" value="{{ old('id_item') }}">
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary btnSave"> Guardar</button>
                <button type="button" class="btn btn-warning" onclick="closeItemModal();"> Salir</button>
            </div>
        </form>
      </div>
    </div>
</div>

