@extends('layouts.app')
@section('title','Generar Formulario')
@section('content')
<style> 
    .table td, .table th {
    border-top: 1px solid #f1f1f1;
    white-space: wrap;
    /* padding: 0.7rem 0.75rem; */
}
</style>
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="page-header-title">
                    <h5 class="m-b-10">Formularios</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
                    <li class="breadcrumb-item">Secciones Formulario</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    <h4>Secciones creadas por formulario</h4>
                    <div>
                        <a href="javascript:void(0);" class="btn btn-primary" onclick="createContent();" >Nuevo Contenido</a>
                    </div>
                </div>
            </div>
            
            <div class="card-body">
                <ul class="nav nav-tabs mb-3" id="myTab" role="tablist">
                    @foreach($formularios_secciones as $key=>$form)
                        @php
                            $puedeVer = auth()->user()->can('ver_formulario_' . $form->idpar_tipoformulario);
                        @endphp
                        @if($form->formulario != null && $puedeVer)
                            <li class="nav-item">
                                <a class="nav-link {{ $activo_id==null && $key == 0 ? ' show active' : ($form->idpar_tipoformulario == $activo_id ? 'show active' : '')  }}" data-toggle="tab" href="#form{{$form->idpar_tipoformulario}}" role="tab" aria-controls="home" aria-selected="true">{{ $form->formulario->nombre }}</a>
                            </li>
                        @endif
                    @endforeach
                </ul>
                <div class="table-responsive">
                    <div class="tab-content" id="myTabContent">
                        @foreach ($formularios_secciones as $k => $f)
                            @php
                                $visualizar = auth()->user()->can('ver_formulario_' . $f->idpar_tipoformulario);
                            @endphp
                            @if($visualizar)
                                <div class="tab-pane fade {{ $activo_id==null && $k == 0 ? 'show active' : ($f->idpar_tipoformulario == $activo_id ? 'show active' : '')  }}" id="form{{$f->idpar_tipoformulario}}" role="tabpanel" aria-labelledby="{{$f->idpar_tipoformulario}}-f">
                                    @can('tipo_formulario.show')<div class="text-right"><a href="{{ route('planillas.show',$f->formulario->idpar_tipoformulario) }}" class="btn btn-success" target="_blank">Ver Formulario</a></div>@endcan
                                    <table class="table table-sm table-hover" id="datos">
                                        <thead>
                                            <tr>
                                                <th class="text-center col-1">Acciones</th>
                                                <th class="text-center col-1">Posición</th>
                                                <th class="text-center col-3">Sección Nombre</th>
                                                <th class="text-center col-7">Variables</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($secciones as $s)
                                                @if($s->idpar_tipoformulario == $f->idpar_tipoformulario)
                                                    <tr>
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center">
                                                                <a href="javascript:void(0);" class="mr-3" title="Modificar datos" onclick="editContent({{$s->idrep_formularioseccion}},'{{ $s->nombre }}','{{ $s->formulario->idpar_tipoformulario }}',{{ $s->orden }})"><i class="fas fa-edit"></i></a>
                                                                <button 
                                                                    class="btn mr-2 text-danger pl-2 pr-2 mr-3 delete-btn"
                                                                    data-id="{{ $s->idrep_formularioseccion }}"
                                                                    data-name={{ $s->nombre }} 
                                                                    data-ruta="{{ route('secciones.destroy',$s->idrep_formularioseccion ) }}"
                                                                    title="Eliminar sección"
                                                                >
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                                <a href="javascript:void(0);" class="text-success mr-3" title="Agregar Campos" onclick="create({{$s->idrep_formularioseccion}})"><i class="fas fa-plus"></i></a>
                                                                <a href="javascript:void(0);" class="text-info" title="Agregar Campo con formula" onclick="itemFormula({{$s}})"><i class="fas fa-percent"></i></a>
                                                            </div>
                                                        </td>
                                                        <td class="text-center"><h3><span class="badge badge-secondary">{{ $s->orden }}</span></h3></td>
                                                        <td class="text-center">{{ $s->nombre }}</td>
                                                        <td class="text-left p-0">
                                                            <table class="m-0" width="100%">
                                                                <tr>
                                                                    <th class="text-center col-1">Acciones</th>
                                                                    <th class="text-center col-1">Posición</th>
                                                                    <th class="text-center col-2">Grupo</th>
                                                                    <th class="text-center col-8">Nombre del Campo</th>
                                                                </tr>
                                                                @foreach($s->contenido as $i)
                                                                    @if($i->eliminado == false)
                                                                    <tr>
                                                                        <td>
                                                                            <div class="d-flex align-items-center justify-content-center">
                                                                                @if($i->tipo_campo != 'calculo')
                                                                                    <a href="javascript:void(0);" class="mr-3" title="Modificar datos" onclick="editarItem({{ $i }})" ><i class="fas fa-edit"></i></a>
                                                                                @else
                                                                                    <a href="javascript:void(0);" class="mr-3" title="Modificar datos" onclick="editarItemCalculo({{ $i }})" ><i class="fas fa-edit"></i></a>
                                                                                @endif
                                                                                <button 
                                                                                    class="btn mr-2 text-danger pl-2 pr-2 mr-3 delete-item-btn"
                                                                                    {{-- data-id="{{ $i->idrep_formulariocontenido }}" --}}
                                                                                    data-name="{{ $i->item->nombre }}"
                                                                                    data-ruta="{{ route('campo.destroy',$i->idrep_formulariocontenido ) }}"
                                                                                    title="Eliminar campo"
                                                                                >
                                                                                    <i class="fas fa-trash"></i>
                                                                                </button>
                                                                            </div>
                                                                        </td>
                                                                        <td class="text-center"><h4><span class="badge badge-secondary">{{ $i->orden_item }}</span></h4></td>
                                                                        <td class="text-left">{{  $i->grupo != null ? $i->grupo->nombre : '' }}</td>
                                                                        <td class="text-left">{{ $i->item->nombre }} @if($i->idpar_unidadmedida != NULL ) ({{ $i->unidad_medida->nombre }}) @endif <br> Tipo Campo: {{ $i->tipo_campo }} @if($i->obligatorio == true) <br> Obligatorio @endif</td>
                                                                    </tr>
                                                                    @endif
                                                                @endforeach
                                                            </table>
                                                        </td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<form id="delete-form" method="POST" style="display:none;">
    @csrf
    @method('DELETE')
</form>
<form id="delete-item-form" method="POST" style="display:none;">
    @csrf
    @method('DELETE')
</form>
@include('secciones.modals.item')
@include('secciones.modals.seccion')
@include('secciones.modals.item_calculo')
@endsection
@section('scripts')
    
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            @if($errors->any())
                var myModal = new bootstrap.Modal(document.getElementById('modalSeccion'));
                myModal.show();
            @endif
            @if($errors->errorItem->any())
                var myModal = new bootstrap.Modal(document.getElementById('modalItem'));
                myModal.show();
            @endif
            @if($errors->errorItemCalculo->any())
                var myModal = new bootstrap.Modal(document.getElementById('itemCalculoModal'));
                myModal.show();
            @endif

            const modal = document.getElementById('modalItem');
            const formulario = document.getElementById('formItem');

            modal.addEventListener('hidden.bs.modal', function () {
                // Limpiar todos los campos del formulario
                formulario.reset();
            });
        });
        // Referencia al input de fórmula
        const formulaInput = document.getElementById('formula');

        // Función para agregar operadores a la fórmula
        function agregarOperador(operador) {
            formulaInput.value += ` ${operador} `;
        }

        // Función para agregar campos seleccionados a la fórmula
        function agregarCampo() {
            const campoSelect = document.getElementById('campos');
            const campoSeleccionado = campoSelect.value;

            if (campoSeleccionado) {
                formulaInput.value += ` c${campoSeleccionado} `;
                campoSelect.selectedIndex = 0; // Reinicia el dropdown
            } else {
                alert('Por favor, selecciona un campo antes de agregarlo.');
            }
        }
        let editor;
        document.querySelectorAll('#valor_predeterminado').forEach((textarea) => {
        ClassicEditor
            .create(textarea)
            .then(editorInstance => {
                editor = editorInstance;
            })
            .catch(error => console.error(error));
    });
    </script>
    <script src="{{ asset('assets/js/pages/items.js') }}"></script>
@endsection