<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>ENCUESTAS Y FORMULARIOS SEDEM Y EPPS</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,600&display=swap" rel="stylesheet" />

        <link rel="icon" href="{{ asset('favicon.ico') }}" type="image/x-icon">
        <link href="https://fonts.googleapis.com/css?family=Lato:300,400,700&display=swap" rel="stylesheet">

        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" href="{{ asset('assets/fonts/fontawesome.css') }}">
        <link rel="stylesheet" href="{{ asset('assets_welcome/css/style.css') }}">
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    </head>
    <body class="" style="background-image: url({{ asset('img/'.$parTipoformulario->fondo) }}); 
    background-size: 100% auto;  
    background-repeat: no-repeat; 
    background-attachment: fixed;
    background-position: center bottom; background-color: {{ $parTipoformulario->color_fondo }}">
        <section class="ftco-section">
            <div class="container">
                <div class="d-flex align-items-center justify-content-end">
                    @auth
                    <a href="{{ route('home') }}" class="" title="Ir al Inicio"><i class="fas fa-home"></i></a>
                    @else
                        <a href="{{ route('login') }}" class="" title="Iniciar Sesión"><i class="fas fa-door-open"></i></a>
                    @endauth
                </div>
                <div class="row justify-content-center">
                    <div class="col-md-10 col-lg-10">
                        <div class="login-wrap pr-4 pl-4 pt-0 pb-0 p-md-5">
                            <div class="row">
                                <div class="col-md-3">
                                    <img src="{{ asset('img/'.$parTipoformulario->logo) }}" class="" style="max-width: 180px;">
                                </div>
                                <div class="col-md-9">
                                    <div class="text-center">
                                        <h3 style="color:{{ $parTipoformulario->color_titulo }};">{{ $parTipoformulario->tipo }} </h3>
                                        <h3 style="color:{{ $parTipoformulario->color_subtitulo }};">{!! nl2br($parTipoformulario->descripcion) !!}</h3>
                                    </div>
                                </div>
                            </div>
                            @if ($errors->any())
                                <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                                <ul class="list-ticked mensaje-error">
                                    @foreach ($errors->all() as $error)
                                        <li class="text-danger">{{ $error }}</li>
                                    @endforeach
                                </ul>
                            @endif
                            @include('sweetalert::alert')
                            <form action="{{ route('planillas.store') }}" method="POST" id="formData">
                                @csrf
                                @include('registro._form_welcome',['submitButtonText' => 'Registrar','tipo'=>1,'origen'=>'show'])
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <script>
            document.querySelectorAll('.confirm-btn').forEach(button => {
            button.addEventListener('click', function () {
                const itemName = this.dataset.name;
                const url=this.dataset.ruta
                // SweetAlert para confirmar eliminación
                Swal.fire({
                    title: `¿Verifico los datos ingresados?`,
                    text: "Una vez registrado ya no se puede modificar.",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Sí, registrar',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Enviar solicitud de eliminación
                        const form = document.getElementById('formData');
                        form.action = url;
                        form.submit();
                    }
                });
            });
        });
   
 
        </script>
    </body>
</html>
