@extends('layouts.app')
@section('title','Registro de Datos')
@section('content')
<div class="page-header">
    <div class="page-block">
        <div class="col-md-12">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <div class="page-header-title">
                        <h5 class="m-b-10">REGISTRO DE {{ $parTipoformulario->nombre }}</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
                        <li class="breadcrumb-item">REGISTRO DE {{ $parTipoformulario->nombre }}</li>
                    </ul>
                </div>
                {{-- <a href="{{ route('planillas.create',$parTipoformulario) }}" class="btn btn-primary">Nuevo Registro</a> --}}
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            @php
                $idFormulario = $parTipoformulario->idpar_tipoformulario;
                $puedeEditar = auth()->user()->can('editar_formulario_' . $idFormulario);
                $puedeEliminar = auth()->user()->can('eliminar_formulario_' . $idFormulario);
                
            @endphp
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    <h4>LISTADO DE REGISTROS DE {{ $parTipoformulario->nombre }}</h4>
                        
                    <div>
                        <a href="{{ route('planillas.show',$parTipoformulario->slug) }}" target="_blank" class="btn btn-secondary">PREVISUALIZAR FORMULARIO</a>
                        @if(count($registros) > 0)
                        <a class="btn btn-success btn-icon" href="{{ route('reportes.excel') }}" onclick="event.preventDefault(); document.getElementById('exportar_excel').submit();" title="Exportar a Excel">
                            <i class="fas fa-file-excel"></i> Exportar a XLS
                        </a>
                        @endif
                        
                    </div>
                </div>
            </div>
            <form id="exportar_excel" action="{{ route('reportes.excel') }}" method="POST" style="display: none;">
                @csrf
                {{ Form::hidden('parTipoformulario', $parTipoformulario->idpar_tipoformulario) }}
                {{ Form::hidden('registros', base64_encode(serialize($registros))) }}
                {{ Form::hidden('secciones', base64_encode(serialize($secciones))) }}
            </form>
            
            <div class="card-body">
                <div class="table-responsive">
                    <p>Los datos de orden por fecha de orden descendente.</p>
                    <table class="table table-hover table-sm" id="scroll-fill">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">Fecha Registro</th>
                                @foreach ($secciones as $sec)
                                    @if($sec->tipo != 'tabla')
                                        <th class="text-center">{{ $sec->item }}</th>
                                    @endif
                                @endforeach
                                
                                <th class="text-center">Nombres</th>
                                <th class="text-center">Cargo</th>
                                <th class="text-center">Unidad</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($registros as $registro)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center justify-content-center">
                                            <a href="{{ route('planilla.pdf', $registro['idrep_formularioplanilladato']) }}" 
                                                    class="pl-2 pr-2 mr-2" 
                                                    title="Imprimir planilla" target="_blank">
                                                    <i class="fas fa-file"></i>
                                                </a>
                                            @if($puedeEditar)
                                                <a href="{{ route('planilla_datos.edit', [$idFormulario, $registro['idrep_formularioplanilladato']]) }}"
                                                    class="pl-2 pr-2 mr-2"
                                                    title="Modificar Registro">
                                                    <i class="fas fa-pen"></i>
                                                </a>
                                            @endif
                                    
                                            @if($puedeEliminar)
                                                
                                                
                                                    
                                                    {!! Form::open(['route'=>['planilla_datos.destroy',$registro['idrep_formularioplanilladato']],'method'=>'DELETE']) !!}
                                                    <button class="btn mr-2 text-danger pl-2 pr-2"  title="Eliminar Registro" onclick="return confirm('�Esta seguro que desea eliminar el Registro?');"><i class="fas fa-trash"></i></button>
                                                {!! Form::close() !!}
                                            @endif
                                        </div>
                                    </td>
                                    <td class="text-center">{{ date('d/m/Y H:m',strtotime($registro['fecha_registro_formulario'])) }}</td>
                                    @foreach ($secciones as $sec)
                                        @if($sec->tipo != 'tabla')
                                            @if(isset($registro['valores'][$sec->cont]))
                                            <td class="text-center" style="white-space: normal; word-wrap: break-word;">
                                                
                                                @switch($registro['tipos'][$sec->cont] )
                                                    @case('date')
                                                        {{ date('d/m/Y',strtotime($registro['valores'][$sec->cont])) ?? '-' }}
                                                        @break
                                                    @case('datetime')
                                                        {{ date('d/m/Y H:m',strtotime($registro['valores'][$sec->cont])) ?? '-' }}
                                                        @break
                                                    @case('text_area')
                                                        ....
                                                        @break
                                                    @case('cargar_documento')
                                                        <a href="{{ asset('adjuntos/'.$registro['valores'][$sec->cont]) }}" target="_blank"> Ver Adjunto</a>
                                                    @default
                                                        {{ $registro['valores'][$sec->cont] ?? '-' }}
                                                        @break
                                                @endswitch
                                            </td>
                                            @else
                                                <td>-</td>
                                            @endif
                                        @endif
                                    @endforeach
                                    
                                    <td class="text-center">{{ $registro['cargo'] }}</td>
                                    <td class="text-center">{{ $registro['unidad'] }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<form id="delete-form" method="POST" style="display:none;">
    @csrf
    @method('DELETE')
</form>
@endsection
@section('scripts')
    <script src="{{ asset('assets/js/tablas/scroll.js') }}"></script>
@endsection