@extends('layouts.app')
@section('title',"Modificar datos generales del formulario")
@section('content')
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="page-header-title">
                    <h5 class="m-b-10">{{ $parTipoformulario->nombre }}</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
                    <li class="breadcrumb-item">{{ $parTipoformulario->nombre }}</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-header">
                <h4>Datos Generales del Formulario</h4>
            </div>
            <div class="card-body">
                @if ($errors->any())
                    <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                    <ul class="list-ticked mensaje-error">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{ $error }}</li>
                        @endforeach
                    </ul>
                @endif
                {!! Form::model($repFormularioplanilladato,['route'=>['planilla_datos.update',$repFormularioplanilladato->idrep_formularioplanilladato],'method'=>'PUT','class'=>'needs-validation']) !!}
                    @include('registro._form',['submitButtonText' => 'Actualizar Datos Generales','tipo'=>2])
                    
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
<script type="text/javascript">
    document.querySelectorAll('.editor').forEach((textarea) => {
        ClassicEditor
            .create(textarea)
            
            .catch(error => console.error(error));
    });
</script>
@endsection