@extends('layouts.app')
@section('title',"Registro")
@section('content')
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="page-header-title">
                    <h5 class="m-b-10">{{ $parTipoformulario->nombre }}</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
                    <li class="breadcrumb-item">{{ $parTipoformulario->nombre }}</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-header">
                <h4>REGISTRO DE {{ $parTipoformulario->nombre }}</h4>
            </div>
            <div class="card-body">
                @if ($errors->any())
                    <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                    <ul class="list-ticked mensaje-error">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{ $error }}</li>
                        @endforeach
                    </ul>
                @endif
                <form action="{{ route('planillas_tabla.store') }}" method="POST">
                    @csrf
                    <input type="hidden" name="idpar_tipoformulario" value="{{ $parTipoformulario->idpar_tipoformulario }}">
                    <input type="hidden" name="idrep_formularioplanilladato" value="{{ $repFormularioplanilladato->idrep_formularioplanilladato }}">
                    <div class="row">
                        <div class="col-md-8">
                            @foreach($secciones as $sec)
                                    <h5 class="mb-3">{{ $sec->nombre }}</h5>
                                    <input type="hidden" name="id_seccion" value="{{ $sec->idrep_formularioseccion }}">
                                    @foreach ($sec->contenido as $i => $cf)
                                        @if($cf->eliminado == false )
                                            <table class="table table-sm" style="margin: 0;">
                                                <tr>
                                                    @if($cf->grupo)
                                                        <td style="width: 20%" class="text-right">{{ $cf->grupo->nombre }}</td>
                                                        <td style="width: 30%" class="text-right">{{ $cf->item->nombre }}</td>
                                                    @else
                                                        <td style="width: 50%" colspan="2" class="text-right">
                                                            {{ $cf->item->nombre }} 
                                                        </td>
                                                    @endif
                                                    <td style="width: 50%">
                                                        @php
                                                            $valor = null; // Variable para almacenar el valor por defecto
                                                        @endphp

                                                        {{-- @if(count($repFormularioplanilladato->registros) > 0)
                                                            @foreach ($repFormularioplanilladato->registros as $datos)
                                                                @if($datos->idrep_formulariocontenido == $cf->idrep_formulariocontenido)
                                                                    @php
                                                                        $valor = $datos->valor; // Si se encuentra un valor, se asigna
                                                                    @endphp
                                                                @endif
                                                            @endforeach
                                                        @endif --}}
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            @switch($cf->tipo_campo)
                                                                    @case('correlativo')
                                                                        <input
                                                                        type="number"
                                                                        name="items[{{ $cf->idrep_formulariocontenido }}]"
                                                                        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
                                                                        {{ $i == 0 ? 'autofocus' : '' }}
                                                                        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor == null ? correlativo($cf->seccion->idpar_tipoformulario,) : $valor) }}" readonly>
                                                                    @break
                                                                    @case('date')
                                                                        <input
                                                                        type="date"
                                                                        name="items[{{ $cf->idrep_formulariocontenido }}]"
                                                                        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
                                                                        {{ $i == 0 ? 'autofocus' : '' }}
                                                                        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor == null ? correlativo($cf->seccion->idpar_tipoformulario,) : $valor) }}">
                                                                    @break
                                                                    @case('text')
                                                                        <input
                                                                        type="text"
                                                                        name="items[{{ $cf->idrep_formulariocontenido }}]"
                                                                        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
                                                                        {{ $i == 0 ? 'autofocus' : '' }}
                                                                        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor) }}">
                                                                    @break
                                                                    @case('email')
                                                                        <input
                                                                        type="email"
                                                                        name="items[{{ $cf->idrep_formulariocontenido }}]"
                                                                        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
                                                                        {{ $i == 0 ? 'autofocus' : '' }}
                                                                        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor) }}">
                                                                    @break
                                                                    @case('text_area')
                                                                        <textarea name="items[{{ $cf->idrep_formulariocontenido }}]" id="" cols="30" rows="5"  class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
                                                                        {{ $i == 0 ? 'autofocus' : '' }}>{{ old('items.' . $cf->idrep_formulariocontenido, $valor) }}</textarea>
                                                                        @break
                                                                    @case('number')
                                                                        <input
                                                                        type="number"
                                                                        name="items[{{ $cf->idrep_formulariocontenido }}]"
                                                                        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
                                                                        {{ $i == 0 ? 'autofocus' : '' }}
                                                                        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor) }}">
                                                                    @break
                                                                    @case('decimal')
                                                                        <input
                                                                        type="number"
                                                                        step="0.01"
                                                                        name="items[{{ $cf->idrep_formulariocontenido }}]"
                                                                        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
                                                                        {{ $i == 0 ? 'autofocus' : '' }}
                                                                        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor) }}">
                                                                    @break
                                                                    @case('select')
                                                                        <select name="items[{{ $cf->idrep_formulariocontenido }}]" class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}">
                                                                            <option value="">--SELECCIONE--</option>
                                                                            @foreach(explode(';', $cf->items_lista) as $item)
                                                                                <option value="{{ $item }}" {{ old('items.' . $cf->idrep_formulariocontenido, $valor) == $item ? 'selected' : '' }}>{{ $item }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    @break
                                                                    @case('bolean')
                                                                        @foreach(explode(';', $cf->items_lista) as $key => $opcion)
                                                                            <div class="form-check">
                                                                                <input 
                                                                                    type="radio" 
                                                                                    name="items[{{ $cf->idrep_formulariocontenido }}]" 
                                                                                    id="opcion_{{ $cf->idrep_formulariocontenido }}_{{ $key }}" 
                                                                                    class="form-check-input {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}" 
                                                                                    value="{{ $opcion }}" 
                                                                                    {{ old('items.' . $cf->idrep_formulariocontenido, $valor) == $opcion ? 'checked' : '' }}>
                                                                                <label for="opcion_{{ $cf->idrep_formulariocontenido }}_{{ $key }}" class="form-check-label">
                                                                                    {{ $opcion }}
                                                                                </label>
                                                                            </div>
                                                                        @endforeach
                                                                    @break  
                                                                    @case('nombre')
                                                                        <select name="items[{{ $cf->idrep_formulariocontenido }}]" id="nombre_persona" class=" {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}">
                                                                            <option value="">--SELECCIONE--</option>
                                                                            @foreach($nombres as $item)
                                                                                <option value="{{ $item }}" {{ old('items.' . $cf->idrep_formulariocontenido, $valor) == $item ? 'selected' : '' }}>{{ $item }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                        @break
                                                                    @case('cargo')
                                                                        <select name="items[{{ $cf->idrep_formulariocontenido }}]" class="cargo {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}">
                                                                            <option value="">--SELECCIONE--</option>
                                                                            @foreach($cargos as $cargo)
                                                                                <option value="{{ $cargo }}" {{ old('items.' . $cf->idrep_formulariocontenido, $valor) == $cargo ? 'selected' : '' }}>{{ $cargo }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                        @break
                                                                    @case('calculo')
                                                                        <input 
                                                                            type="text" 
                                                                            id="calculo_{{ $cf->idrep_formulariocontenido }}" 
                                                                            name="items[{{ $cf->idrep_formulariocontenido }}]" 
                                                                            class="form-control calculo" 
                                                                            readonly 
                                                                            data-formula="{{ $cf->item_formula }}" >
                                                                    @break 
                                                            
                                                            @endswitch
                                                            &nbsp;&nbsp;@if($cf->idpar_unidadmedida != null) <strong class="text-primary">({{  $cf->unidad_medida->simbolo }})</strong> @endif
                                                        </div>
                                                    </td>
                                                </tr>
                                            </table>
                                        @endif
                                    @endforeach
                            @endforeach
                        </div>
                    </div>
                    
                    <div class="text-center">
                        <button class="btn btn-primary" type="submit" onclick="return confirm('¿Desea guardar?')">Registrar</button>
                        <a href="{{ route('planillas.index',$parTipoformulario->idpar_tipoformulario) }}" class="btn btn-warning">Terminar y Salir</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@if($datosVista != null)
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-body">
                <table class="table table-hover table-sm">
                    <thead>
                        <tr>
                            <th class="text-center">Acciones</th>
                            <th class="text-center">Nro.</th>
                            @foreach($cabecera as $sec)
                            <th class="text-center">{{ $sec->item }}</th>
                            @endforeach
                            
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datosVista as $registro)
                            @if($registro['nro_item'] != null)
                                <tr>
                                    <td class="text-center">
                                        <button 
                                            class="btn mr-2 text-danger pl-2 pr-2 delete-btn"
                                            {{-- data-id="{{ $i->idrep_formulariocontenido }}" --}}
                                            data-name="{{ $registro['nro_item'] }}"
                                            data-ruta="{{ route('registro.destroy',[$registro['idPlanilla'],$registro['nro_item'],$registro['seccion']] ) }}"
                                            title="Eliminar registro"
                                        >
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </td>
                                    <td class="text-center">
                                        {{ $registro['nro_item'] }}
                                    </td>
                                    @foreach ($cabecera as $sec)
                                        <td class="text-center">
                                            {{ $registro['valores'][$sec->cont] ?? '-' }}
                                        </td>
                                    @endforeach
                                </tr>
                            @endif
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endif
<form id="delete-form" method="POST" style="display:none;">
    @csrf
    @method('DELETE')
</form>
@endsection
@section('scripts')
    <script>
        $('#nombre_persona').select2({
            width: '100%'
        });
        $('.cargo').select2({
            width: '100%'
        });
        document.addEventListener('DOMContentLoaded', function () {
        // Manejador del botón eliminar
        updateCalculos();
        // Escucha cambios en los campos numéricos
        document.querySelectorAll('.campo_calculo').forEach(input => {
            input.addEventListener('input', updateCalculos);
        });

        function updateCalculos() {
            // Itera sobre todos los campos de cálculo
            document.querySelectorAll('.calculo').forEach(campoCalculo => {
                const formula = campoCalculo.dataset.formula; // Obtiene la fórmula
                let resultado = formula;
                console.log(resultado);

                // Reemplaza los IDs prefijados con "c" en la fórmula con los valores actuales
                document.querySelectorAll('.campo_calculo').forEach(campo => {
                    const id = campo.dataset.id; // Obtiene el "cID"
                    const valor = parseFloat(campo.value) || 0; // Valor o 0 si está vacío
                    resultado = resultado.replace(new RegExp(`\\b${id}\\b`, 'g'), valor);
                    console.log(id,valor,resultado);
                });

                try {
                    // Evalúa la fórmula y actualiza el campo de cálculo
                    campoCalculo.value = eval(resultado).toFixed(2);
                } catch (e) {
                    campoCalculo.value = "Error";
                }
            });
        }
        document.querySelectorAll('.delete-btn').forEach(button => {
            button.addEventListener('click', function () {
                const itemName = this.dataset.name;
                const url=this.dataset.ruta
                // SweetAlert para confirmar eliminación
                Swal.fire({
                    title: `¿Está seguro de eliminar el registro "${itemName}"?`,
                    text: "Esta acción no se puede deshacer.",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Sí, eliminar',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Enviar solicitud de eliminación
                        const form = document.getElementById('delete-form');
                        form.action = url;
                        form.submit();
                    }
                });
            });
        });
    });
    </script>
@endsection