@extends('layouts.app')
@section('title',"Registro")
@section('content')
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="page-header-title">
                    <h5 class="m-b-10">{{ $parTipoformulario->nombre }}</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
                    <li class="breadcrumb-item">{{ $parTipoformulario->nombre }}</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-header">
                <h4>REGISTRO DE {{ $parTipoformulario->nombre }}</h4>
            </div>
            <div class="card-body">
                @if ($errors->any())
                    <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                    <ul class="list-ticked mensaje-error">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{ $error }}</li>
                        @endforeach
                    </ul>
                @endif
                <form action="{{ route('planillas.store') }}" method="POST">
                    @csrf
                    @include('registro._form',['submitButtonText' => 'Registrar','tipo'=>1])
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
<script type="text/javascript">
    $('.nombre_persona').select2({
        dropdownParent: $('#modalItem .modal-body'),
        width: '100%'
    });
    $('.cargo').select2({
        dropdownParent: $('#modalItem .modal-body'),
        width: '100%'
    });
    document.querySelectorAll('.editor').forEach((textarea) => {
            ClassicEditor
                .create(textarea)
                
                .catch(error => console.error(error));
        });
        $(document).on('change', 'input[type="file"]', function (event) {
        let input = $(this);
        let fieldId = input.data('id');
        let previewContainer = $('#preview-' + fieldId);
        let filesListContainer = $('#files-list-' + fieldId);

        let currentFiles = filesListContainer.data('files') || []; // Obtener archivos existentes
        let newFiles = Array.from(event.target.files); // Obtener los archivos reales
        let allFiles = [...currentFiles, ...newFiles.map(file => file.name)]; // Guardar solo nombres

        filesListContainer.data('files', allFiles); // Guardar la lista actualizada en data-files
        
        previewContainer.html(''); // Limpiar vista previa antes de agregar nuevas imágenes
        filesListContainer.html(''); // Limpiar lista de archivos para volver a generarla

        newFiles.forEach(file => {
            if (file.type.startsWith('image/')) {
                let imgSrc = URL.createObjectURL(file);
                let imgTag = `<img src="${imgSrc}" class="img-thumbnail m-1" style="width:100px;">`;
                previewContainer.append(imgTag);
            }
        });

        allFiles.forEach(file => {
            let fileTag = `<div class="file-item" data-file="${file}">
                            <a href="/adjuntos/${file}" target="_blank" class="btn btn-primary btn-link btn-sm">
                                <i class="fa fa-file"></i> ${file}
                            </a>
                            <button type="button" class="btn btn-danger btn-sm delete-file" 
                                data-file="${file}" 
                                data-id="${fieldId}">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>`;
            filesListContainer.append(fileTag);
        });
    });
</script>
@endsection