@switch($cf->tipo_campo)
    @case('correlativo')
        <input
        type="number"
        name="items[{{ $cf->idrep_formulariocontenido }}]"
        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
       
        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor == null ? correlativo($cf->seccion->idpar_tipoformulario) : $valor) }}" readonly>
        @break
    @case('date')
        <input
        type="date"
        name="items[{{ $cf->idrep_formulariocontenido }}]"
        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
       
        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor) }}">
        @break
    @case('datetime')
        <input
        type="datetime-local"
        name="items[{{ $cf->idrep_formulariocontenido }}]"
        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
       
        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor) }}">
        @break
    @case('email')
        <input
        type="email"
        name="items[{{ $cf->idrep_formulariocontenido }}]"
        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
       
        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor) }}">
        @break
    @case('text')
        <input
        type="text"
        name="items[{{ $cf->idrep_formulariocontenido }}]"
        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
       
        value="{{ old('items.' . $cf->idrep_formulariocontenido, ($valor == null ? ($cf->valor_predeterminado != null ? $cf->valor_predeterminado : '') : $valor )) }}">
        @break
    @case('CI')
        <input
        type="text"
        name="items[{{ $cf->idrep_formulariocontenido }}]"
        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
       
        value="{{ old('items.' . $cf->idrep_formulariocontenido, ($valor == null ? ($cf->valor_predeterminado != null ? $cf->valor_predeterminado : '') : $valor )) }}">
        @break
    @case('text_area')
        <textarea name="items[{{ $cf->idrep_formulariocontenido }}]" id="textarea_{{ $cf->idrep_formulariocontenido }}"  cols="10" rows="5"  class="editor form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
       >{{ old('items.' . $cf->idrep_formulariocontenido, ($valor != null ? $valor : ($cf->valor_predeterminado != null ? $cf->valor_predeterminado : ''))) }}</textarea>
        @break
    @case('number')
        <input
        type="number"
        name="items[{{ $cf->idrep_formulariocontenido }}]"
        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
       
        value="{{ old('items.' . $cf->idrep_formulariocontenido, ( $valor != null ? $valor : ( $cf->valor_predeterminado != null ? $cf->valor_predeterminado : ''))) }}">
        @break
    @case('decimal')
        <input
        type="number"
        step="0.01"
        name="items[{{ $cf->idrep_formulariocontenido }}]"
        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
       
        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor == null ? ($cf->valor_predeterminado != null ? $cf->valor_predeterminado : '') : $valor ) }}">
        @break
        @case('time')
        <input
        type="time"
        name="items[{{ $cf->idrep_formulariocontenido }}]"
        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
       
        value="{{ old('items.' . $cf->idrep_formulariocontenido, $valor == null ? ($cf->valor_predeterminado != null ? $cf->valor_predeterminado : '') : $valor ) }}">
        @break
    @case('select')
        <select name="items[{{ $cf->idrep_formulariocontenido }}]" class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}">
            <option value="">--SELECCIONE--</option>
            @foreach(explode(';', $cf->items_lista) as $item)
                <option value="{{ $item }}" {{ old('items.' . $cf->idrep_formulariocontenido, $valor) == $item ? 'selected' : '' }}>{{ $item }}</option>
            @endforeach
        </select>
        @break
    @case('bolean')
        <div class="text-left ml-3"> 
            @foreach(explode(';', $cf->items_lista) as $key => $opcion)
                <div class="form-check{{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}">
                    <input
                        type="radio"
                        name="items[{{ $cf->idrep_formulariocontenido }}]"
                        id="opcion_{{ $cf->idrep_formulariocontenido }}_{{ $key }}"
                        class="form-check-input {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
                        value="{{ $opcion }}"
                        {{ old('items.' . $cf->idrep_formulariocontenido, $valor) == $opcion ? 'checked' : '' }}>
                    <label for="opcion_{{ $cf->idrep_formulariocontenido }}_{{ $key }}" class="form-check-label">
                        {{ $opcion }}
                    </label>
                </div>
            @endforeach
        </div>
        @break
    @case('calculo')
        <input 
            type="text" 
            id="calculo_{{ $cf->idrep_formulariocontenido }}" 
            name="items[{{ $cf->idrep_formulariocontenido }}]" 
            class="form-control calculo" 
            readonly 
            data-formula="{{ $cf->item_formula }}" >
    @break
    @case('seleccion_multiple')
        @foreach(explode(';', $cf->items_lista) as $key => $opcion)
            <div class="ml-3 form-check {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}">
                <input 
                    type="checkbox" 
                    name="items[{{ $cf->idrep_formulariocontenido }}][]" 
                    id="opcion_{{ $cf->idrep_formulariocontenido }}_{{ $key }}" 
                    class="form-check-input {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}" 
                    value="{{ $opcion }}" 
                    {{ is_array(old('items.' . $cf->idrep_formulariocontenido, $valor)) && in_array($opcion, old('items.' . $cf->idrep_formulariocontenido, $valor)) ? 'checked' : '' }}>
                <label for="opcion_{{ $cf->idrep_formulariocontenido }}_{{ $key }}" class="form-check-label">
                    {{ $opcion }}
                </label>
            </div>
        @endforeach
        @break
    @case('solo_numeros')
    <input 
        type="text" 
        oninput="this.value = this.value.replace(/[^0-9]/g, '')" 
        maxlength="8"
        name="items[{{ $cf->idrep_formulariocontenido }}]"
        class="form-control {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
       
        value="{{ old('items.' . $cf->idrep_formulariocontenido, ($valor == null ? ($cf->valor_predeterminado != null ? $cf->valor_predeterminado : '') : $valor )) }}">
        
    @break

    @case('parrafo')
        <div class="parrafo">{!! $cf->valor_predeterminado !!}</div>
    @break
    @case('checkbox')
        <div class="text-center">
            <div class="form-check {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}">
                <input
                    type="checkbox"
                    name="items[{{ $cf->idrep_formulariocontenido }}]"
                    id="opcion_{{ $cf->idrep_formulariocontenido }}"
                    class="form-check-input {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
                    value="1"
                    {{ old('items.' . $cf->idrep_formulariocontenido, $valor) == 1 ? 'checked' : '' }}>
                <label for="opcion_{{ $cf->idrep_formulariocontenido }}" class="form-check-label">
                    {{ $cf->valor_predeterminado }}
                </label>
            </div>
        </div>
    @break
    @case('cargar_documento')
        
        <input
            type="file"
            data-id="{{ $cf->idrep_formulariocontenido }}"
            name="items[{{ $cf->idrep_formulariocontenido }}]"
            id="items{{ $cf->idrep_formulariocontenido }}"
            class="form-control campo-editable {{ $errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : '' }}"
            accept=".pdf"
            {{ $cf->obligatorio == 1 && $valor == null ? 'required' : '' }} 
           
            >
        <div id="preview-{{ $cf->idrep_formulariocontenido }}" class="mt-2"></div>

        @if($valor != null)
            <label class="mt-2">Documentos Adjuntos:</label>
            @foreach(explode(';', $valor) as $file)
                <small>
                    <a href="{{ asset('adjuntos/'.$file) }}" target="_blank" class="btn btn-primary btn-link btn-sm">
                        <i class="fa fa-file-pdf"></i> {{ $file }}
                    </a>
                    <button type="button" class="btn btn-danger btn-sm delete-file" data-file="{{ $file }}" data-id="{{ $cf->idrep_formulariocontenido }}">
                        <i class="fa fa-trash"></i>
                    </button>
                </small>
            @endforeach
        @endif
        @break
@endswitch