<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>{{ config('app.name') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,600&display=swap" rel="stylesheet" />

        <link rel="icon" href="{{ asset('favicon.ico') }}" type="image/x-icon">
        <link href="https://fonts.googleapis.com/css?family=Lato:300,400,700&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="{{ asset('assets/fonts/fontawesome.css') }}">
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
        
        <link rel="stylesheet" href="{{ asset('assets_welcome/css/style.css') }}">
    </head>
    <body style="background-image: url({{ asset('img/'.$parTipoformulario->fondo) }}); 
    background-size: 100% auto;  
    background-repeat: no-repeat; 
    background-attachment: fixed;
    background-position: center bottom; background-color: {{ $parTipoformulario->color_fondo }}">
        <section class="ftco-section">
            <div class="container">
                <div class="d-flex align-items-center justify-content-end">
                    @auth
                        <a href="{{ route('home') }}" class="" title="Ir al Inicio"><i class="fas fa-home"></i></a>
                    @else
                        <a href="{{ route('login') }}" class="" title="Iniciar Sesión"><i class="fas fa-door-open"></i></a>
                    @endauth
                </div>
                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-10">
                        <div class="login-wrap pr-4 pl-4 pt-0 pb-0 p-md-5">
                            <div class="row">
                                <div class="col-md-2">
                                    <img src="{{ asset('img/'.$parTipoformulario->logo) }}" class="" style="width: 250px;">
                                </div>
                                <div class="col-md-10">
                                    <div class="text-center">
                                        <h2 style="color:{{ $parTipoformulario->color_titulo }}">{{ $parTipoformulario->tipo }} </h2>
                                        <h2 style="color:{{ $parTipoformulario->color_subtitulo }}">{{ $parTipoformulario->descripcion }}</h2>
                                    </div>
                                </div>
                            </div>
                            <br><br>
                            <h4 >{{ $parTipoformulario->mensaje_de_llenado_formulario }}</h4>
                            <h4 >Gracias por su tiempo!!!</h4>

                            <div class="form-group">
                                <a href="{{ route('publicar_formulario.index',$parTipoformulario->slug) }}" class="btn btn-primary rounded submit p-3 px-5">LLENAR {{ $parTipoformulario->tipo }}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </body>
</html>
