
<nav class="pc-sidebar ">
    <div class="navbar-wrapper">
        <div class="m-header d-flex">
            <a href="index.html" class="b-brand text-center" style="width: 100%;">
                <h2 class="display-5 text-white font-weight-bold">{{ config('app.name') }}</h2>
            </a>
        </div>

        <div class="navbar-content">
            <ul class="pc-navbar">
                <li class="pc-item">
                    <a href="{{ route('home') }}" class="pc-link "><span class="pc-micon"><i data-feather="home"></i></span><span class="pc-mtext">Inicio</span></a>
                {{-- </li>
                <li class="pc-item">
                    <a href="{{ route('empresa.index') }}" class="pc-link "><span class="pc-micon"><i data-feather="settings"></i></span><span class="pc-mtext">Configuración</span></a>
                </li> --}}
                @can('tipo_formulario.index')
                    <li class="pc-item {{ isActive('tipo_formulario*') }}">
                        <a href="{{ route('tipo_formulario.index') }}" class="pc-link "><span class="pc-micon"><i data-feather="settings"></i></span><span class="pc-mtext">Tipo Formulario</span></a>
                    </li>
                    <li class="pc-item {{ isActive('formularios*') }}">
                        <a href="{{ route('formularios.index') }}" class="pc-link "><span class="pc-micon"><i data-feather="settings"></i></span><span class="pc-mtext">Crear Contenido Formulario</span></a>
                    </li>
                @endcan
                @if(auth()->user()->can('users.index') || auth()->user()->can('roles.index'))
                    <li class="pc-item pc-hasmenu {{ isActiveList(['users*', 'roles*']) }}">
                        <a href="#!" class="pc-link"><span class="pc-micon"><i data-feather="lock"></i></span><span class="pc-mtext">Permisos</span><span class="pc-arrow"><i data-feather="chevron-right"></i></span></a>
                        <ul class="pc-submenu">
                            <li class="pc-item {{ isActiveRoute(['users*']) }}"><a class="pc-link" href="{{ route('users.index') }}">Usuarios</a></li>
                            <li class="pc-item {{ isActiveRoute('roles*') }}"><a class="pc-link" href="{{ route('roles.index') }}">Roles</a></li>
                            <li class="pc-item {{ isActiveRoute('permisos*') }}"><a class="pc-link" href="{{ route('perfil.permisos.index') }}">Permisos Formulario</a></li>
                        </ul>
                    </li>
                @endif
                @if ($opciones)
                    @foreach ($opciones as $op)
                     @php
                        $puedeRegistrar = auth()->user()->can('ver_formulario_' . $op->idpar_tipoformulario);
                    @endphp
                
                        @if ($puedeRegistrar)
                            <li class="pc-item {{ isActive([
                                    'planillas/'.$op->idpar_tipoformulario.'*',
                                    'nueva_planilla/'.$op->idpar_tipoformulario
                                ]) }}">
                                <a href="{{ route('planillas.index', $op->idpar_tipoformulario) }}" class="pc-link "><span
                                        class="pc-micon"><i data-feather="file-text"></i></span><span
                                        class="pc-mtext">{{ $op->nombre }} </span></a>
                            </li>
                        @endif
                    @endforeach
                @endif
            </ul>
        </div>
    </div>
</nav>
