<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') | {{ config('app.name') }}</title>

    @include('layouts.partials.styles')
</head>
<body>
    <!-- [ Pre-loader ] start -->
	<div class="loader-bg">
		<div class="loader-track">
			<div class="loader-fill"></div>
		</div>
	</div>
    <div class="pc-mob-header pc-header">
		<div class="pcm-logo">
			<h2 class="text-white">{{ config('app.name') }}</h2>
		</div>
		<div class="pcm-toolbar">
			<a href="#!" class="pc-head-link" id="mobile-collapse">
				<div class="hamburger hamburger--arrowturn">
					<div class="hamburger-box">
						<div class="hamburger-inner"></div>
					</div>
				</div>
				<!-- <i data-feather="menu"></i> -->
			</a>
			<a href="{{ route('logout') }}" class="pc-head-link dropdown-toggle arrow-none mr-0" title="Cerrar Sesión"
                onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <i data-feather="power" class="text-danger"></i>
                <form id="logout-form" action="{{ route('logout') }}" method="POST"
                    style="display: none;">
                    @csrf
                </form>
            </a>
			<a href="#!" class="pc-head-link" id="header-collapse">
				<i data-feather="more-vertical"></i>
			</a>
		</div>
	</div>
	<!-- [ Pre-loader ] End -->
    @include('layouts.partials.menu')

    @include('layouts.partials.topbar')

    <div class="pc-container">
        <div class="pcoded-content">
            @include('sweetalert::alert')
            @yield('content')
        </div>
    </div>
    @include('layouts.partials.scripts')

</body>
</html>
