@extends('layouts.app')
@section('title','Inicio')
@section('content')
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="page-header-title">
                    <h5 class="m-b-10">Resúmen de información</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}">Inicio</a></li>
                    <li class="breadcrumb-item">Resúmen de información</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-body">
                <h6>Bienvenid@ al sistema de registro de formularios de inscripción</h6>
                
            </div>
        </div>
    </div>
</div>
<div class="row">
@foreach($formularios as $form)
    @php
        $puedeVer = auth()->user()->can('ver_formulario_' . $form->idpar_tipoformulario);
    @endphp
    @if($puedeVer)
        @foreach($conteo as $c)
            @if($c->idpar_tipoformulario == $form->idpar_tipoformulario)
                <div class="col-md-3">
                    <div class="card text-center">
                        <div class="card-body">
                            <h5 class="card-title">{{ $form->nombre }}</h5>
                            <p class="card-text">Total de registros: {{ $c->total }}</p>
                            <a href="{{ route('planillas.index', $form->idpar_tipoformulario) }}" class="btn btn-primary">Ver registros</a>
                        </div>
                    </div>
                </div>
            @endif
        @endforeach
    @endif
@endforeach
</div>
@endsection
@section('scripts')
<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/export-data.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>
<script src="{{asset('assets/js/pages/graficos.js')}}"></script>
@endsection