<!DOCTYPE html>
<html>

<head>
    <title>Laravel 11 Ajax Image Upload Example - Tutsmake.com</title>

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <style>
        input[type="file"] {
            display: none;
        }

        /* Estilo personalizado para el botón */
        .upload-button {
            background-color: #4CAF50;
            /* Color de fondo */
            color: white;
            /* Color del texto */
            padding: 10px 20px;
            /* Espaciado alrededor del texto */
            border-radius: 5px;
            /* Bordes redondeados */
            cursor: pointer;
            /* Cambiar el cursor al pasar sobre el botón */
            font-size: 16px;
            /* Tamaño de fuente */
            display: inline-block;
            text-align: center;
        }

        .upload-button:hover {
            background-color: #45a049;
            /* Cambio de color al pasar el mouse */
        }
    </style>

</head>

<body>

    <div class="container mt-4">

        <h2 class="text-center">Laravel 11 Ajax Image Upload Example - Tutsmake.com</h2>

        <form method="POST" enctype="multipart/form-data" id="image-upload" action="javascript:void(0)">

            <div class="row" style="margin-left: 19%">

                <div class="col-md-12 mb-2">
                    <div class="form-group">
                        <label class="upload-button">Subir Logo
                            <input type="file" name="image" placeholder="Choose image" id="image">
                        </label>
                    </div>
                </div>

                <div class="col-md-12 mb-2">
                    <button type="submit" class="btn btn-primary" id="submit">Submit</button>
                </div>
            </div>
        </form>
    </div>


    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function(e) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });


            $('#image-upload').submit(function(e) {

                e.preventDefault();

                var formData = new FormData(this);

                $('#submit').text('Please wait').attr('disabled', 'disabled');

                $.ajax({
                    type: 'POST',
                    url: "{{ url('upload') }}",
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: (data) => {
                        $('#submit').text('submit').removeAttr('disabled');
                        this.reset();
                        alert('Image has been uploaded using jQuery ajax successfully');
                    },
                    error: function(data) {
                        console.log(data);
                        $('#submit').text('submit').removeAttr('disabled');
                    }
                });
            });
        });
    </script>
</body>

</html>
