@extends('layouts.app')
@section('title', 'Plantilla')
@section('content')
    <style>
        input[type="file"] {
            display: none;
        }
    </style>
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <div class="col-xl-4 col-md-6">
                        <div class="card-header">
                            <h4>Datos de la empresa</h4>
                        </div>
                    </div>
                    <div class="card-body table-border-style">
                        <div class="table-responsive">
                            <table class="table table-hover table-sm">
                                <thead>
                                    <tr>
                                        <th class="text-center">Acciones</th>
                                        <th class="text-center">Nombre</th>
                                        <th class="text-center">Sigla</th>
                                        <th class="text-center">Logo</th>
                                        <th class="text-center">Color</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($result as $item)
                                        <tr>
                                            <td class="text-center">
                                                {{--  @can('users.edit') --}}
                                                <a href="javascript:void(0);" class="btn-editar "
                                                    data-id="{{ $item->idpar_empresa }}"><i
                                                        class="fas fa-edit"></i></a>
                                                {{-- @endcan --}}
                                            </td>
                                            <td class="text-center">{{ $item->nombre }}</td>
                                            <td class="text-center">{{ $item->sigla }}</td>
                                            <td class="text-center">
                                                @if ($item->logo)
                                                    <img class="form-control" src="{{ asset('img/' . $item->logo) }}" alt="Vista previa Logo" style="max-width: 150px; height: auto;" />
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                <div style="background: {{ $item->color }};">&nbsp;</div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('empresa._modal')

@endsection
@section('scripts')
    <script>
        $(document).ready(function(e) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#formUpdate').submit(function(e) {
                e.preventDefault(); // Evita que el formulario se envíe de forma tradicional
                // Recoger los datos del formulario
                var formData = new FormData(this);
                $('#enviarActualizar').text('Espere por favor').attr('disabled', 'disabled');
                $.ajax({
                    type: 'POST',
                    url: "empresa/" + deleteId,
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: (data) => {
                        $('#enviarActualizar').text('submit').removeAttr('disabled');
                        this.reset(); // Limpiar el formulario
                        // Mostrar la respuesta del servidor en el div #respuesta
                        $('.mensaje').html(
                            "<div class='alert alert-primary' role=alert'>Registro agregado correctamente!<div/>"
                        );
                        $('.imagePreviewContainer').hide();
                        $('.imagePreview').attr('src', '');
                        $('#editModal').modal('hide');
                        $('.mensaje').html("");
                        location.reload(); // Recargar la página o hacer algo con la respuesta
                        /* alert('Image has been uploaded using jQuery ajax successfully'); */
                    },
                    error: function(xhr, status, error) {
                        // Mostrar un mensaje de error si ocurre un problema
                        $('#enviarActualizar').text('Actualizar').removeAttr('disabled');
                        var errors = xhr.responseJSON.errors;
                        var errorMessage = '';

                        if (errors) {
                            var errorMessage =
                                "<h5 class='text-danger'>Errores por corregir:</h5><ul class='list-ticked'>";
                            $.each(errors, function(field, messages) {
                                errorMessage += "<li class='text-danger'>" + messages[
                                    0] + "</li>";
                            });
                            $('.mensaje').html(
                                "<div class='' role=alert'>" +
                                errorMessage + "<div/>");
                        }
                    }
                });
            });

            // Al escribir en el campo 'nombre', convertir el texto a mayúsculas
            $('.txtNombre').on('input', function() {
                // Convertir el valor del campo a mayúsculas
                var texto = $(this).val();
                $(this).val(texto.toUpperCase());
            });
            $('.txtSigla').on('input', function() {
                // Convertir el valor del campo a mayúsculas
                var texto = $(this).val();
                $(this).val(texto.toUpperCase());
            });

            var deleteId;
            // Mostrar el modal y guardar el ID del elemento a eliminar
            $('.delete-btn').on('click', function() {
                deleteId = $(this).attr('data-id'); // Obtener el ID del producto a eliminar
                $('#deleteModal').modal('show'); // Mostrar el modal
            });

            $('.btn-editar').on('click', function() {
                $('.mensaje').html("");
                deleteId = $(this).attr('data-id'); // Obtener el ID del producto a eliminar
                $('#editModal').modal('show'); // Mostrar el modal


                $.ajax({
                    url: 'empresa/' + deleteId + '/edit/', // URL de eliminación
                    type: 'GET',
                    data: {
                        _token: '{{ csrf_token() }}' // CSRF Token
                    },
                    success: function(response) {
                        $('#deleteModal').modal('hide'); // Cerrar el modal
                        if (response.estado == true) {
                            $("#estadoTrueEdit").prop('checked', true);
                            $("#estadoFalseEdit").prop('checked', false);
                        } else {
                            $("#estadoTrueEdit").prop('checked', false);
                            $("#estadoFalseEdit").prop('checked', true);
                        }
                        var logo = response.logo;

                        if (logo) {
                            $('.imagePreview').attr("src",
                                "{{ asset('img') }}" + "/" + logo);
                            $('.imagePreviewContainer').show();
                        }
                        $("#nombreEdit").val(response.nombre);
                        $("#siglaEdit").val(response.sigla);
                        $("#color").val(response.color);

                        /* location.reload(); // Recargar la página o hacer algo con la respuesta */
                    },
                    error: function(xhr, status, error) {
                        console.log(error);
                        //alert('Error al editar el registro. Intente nuevamente.');
                    }
                });


            });

            // Confirmar la eliminación
            $('#confirmDeleteBtn').on('click', function() {
                // Enviar la solicitud AJAX para eliminar el registro
                $.ajax({
                    url: 'empresa/' + deleteId, // URL de eliminación
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}' // CSRF Token
                    },
                    success: function(response) {
                        $('#deleteModal').modal('hide'); // Cerrar el modal
                        location.reload(); // Recargar la página o hacer algo con la respuesta
                    },
                    error: function(xhr, status, error) {
                        alert('Error al eliminar el registro. Intente nuevamente.');
                    }
                });
            });
            $('.image').change(function() {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {

                        $('.imagePreview').attr('src', e.target.result);
                        $('.imagePreviewContainer').show();
                    };
                    reader.readAsDataURL(file);
                } else {
                    $('.imagePreviewContainer').hide();
                }
            });
        });
    </script>

@endsection
