
@extends('layouts.app')
@section('titulo','Permisos del Rol')
@section('content')
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-12">
                <div class="page-header-title">
                    <h5>Permisos del Rol</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}"><i class="feather icon-home"></i></a></li>
                    <li class="breadcrumb-item"><a href="#!">Permisos</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('roles.index') }}">Roles</a></li>
                    <li class="breadcrumb-item"><a href="#!">Permisos del Rol</a></li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
             <div class="card-header">
                  <div class="card-title">{{ $role->name }}</div>
                  <a href="{{route('roles.index')}}" class="btn btn-warning btn-round">Salir</a>
              </div>
              <div class="card-body">
                <ul class="list-unstyled">
                  @foreach($permissions as $permission)
                  <li>
                      <label>
                          <strong>{{$permission->descripcion ?: 'Sin descripción'}}</strong>
                          <em>({{$permission->name}})</em>
                      </label>
                  </li>
                  @endforeach
                </ul>
              </div>
        </div>
    </div>
</div>

@endsection