$('#scroll-fill').dataTable({

    scrollY: 600,
    scrollX: true, 
    scrollCollapse: true,
    paging: false,
    autoFill: false,
    ordering: false,
});

document.addEventListener('DOMContentLoaded', function () {
    // Manejador del botn eliminar
    document.querySelectorAll('.delete-btn').forEach(button => {
        button.addEventListener('click', function () {
            const itemId = this.dataset.id;

            // SweetAlert para confirmar eliminacin
            Swal.fire({
                title: `Est seguro de eliminar el registro?`,
                text: "Esta accin no se puede deshacer.",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'S, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Enviar solicitud de eliminacin
                    const form = document.getElementById('delete-form');
                    form.action = url_global + `/planilla/${itemId}`;
                    form.submit();
                }
            });
        });
    });

    document.querySelectorAll('.aprobar-btn').forEach(button => {
        button.addEventListener('click', function (e) {
            e.preventDefault(); // Detener el comportamiento por defecto del enlace
    
            const url = this.dataset.url;
            const estado = this.dataset.estado;
            Swal.fire({
                title: 'Est seguro que desea '+estado+' el registro?',
                text: "Esta accin no se puede deshacer.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'S, '+estado,
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Redirige si se confirma
                    window.location.href = url;
                }
            });
        });
    });
});