$(document).ready(function () {
    // Setup - add a text input to each footer cell
    $.fn.dataTable.Api.register('column().searchable()', function() {
        var ctx = this.context[0];
        return ctx.aoColumns[this[0]].bSearchable;
      });
      
      function createDropdowns(api) {
          api.columns().every(function() {
              if (this.searchable()) {
                  var that = this;
                  var col = this.index();
      
                  // Only create if not there or blank
                  var selected = $('thead tr:eq(1) td:eq(' + col + ') select').val();
                  if (selected === undefined || selected === '' ) {
                      // Create the `select` element
                      $('thead tr:eq(1) td')
                          .eq(col)
                          .empty();
                      var select = $('<select class="form-control select" ><option value=""></option></select>')
                          .appendTo($('thead tr:eq(1) td').eq(col))
                          .on('change', function() {
                              that.search($(this).val()).draw();
                              createDropdowns(api);
                          });
      
                      api
                          .cells(null, col, {
                              search: 'applied'
                          })
                          .data()
                          .sort()
                          .unique()
                          .each(function(d) {
                              select.append($('<option>' + d + '</option>'));
                          });
                  }
              }
          });
      }
      $('.select').select2();
          // Create the DataTable
        var table = $('#datos').DataTable({
        "language": {
            "processing": "Procesando...",
            "lengthMenu": 'Filtrar <select>'+
                '<option value="10">10</option>'+
                '<option value="20">20</option>'+
                '<option value="30">30</option>'+
                '<option value="40">40</option>'+
                '<option value="50">50</option>'+
                '<option value="-1">Todos</option>'+
                '</select> Registros',
            "paginate": {
                "sFirst":    "Primero",
                "sLast":    "Último",
                "sNext":    "Siguiente",
                "sPrevious": "Anterior"
            },
            "info": "Pagina _PAGE_ de _PAGES_",
            "search": "Buscador Gral",
            "emptyTable": "No existen datos registrados.",
            "infoEmpty": "",
        },
        fixedHeader: true,
        orderCellsTop: true,
        pageLength: 50,
        columnDefs: [
            {
                searchable: false,
                targets: [3]
            }
        ],
        initComplete: function() {
            createDropdowns(this.api());
        }
      });

});