function obtenerDatosGeneral(sec,fecha,title,tipoFormulario) {
    // Generar un gráfico para cada sección
    $.ajax({
        url: url_global +"/reporte_general/"+sec+"/"+fecha+"/"+tipoFormulario,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            console.log(response,response[1].length );
            var categorias = [];
            var datos = [];
            for (var j in response[0]) {
                categorias.push(response[0][j].item);
                datos.push(parseFloat(response[0][j].total));
            }
            if(response[1].length > 0){ 
                var html='';
                html += '<div class="row">';
                for (var k in response[1]) {
                    categorias.push(response[1][k].item);
                    datos.push(parseFloat(response[1][k].total));
                    html += '<div class="col-sm-6">';
                        html += '<div class="card prod-p-card background-pattern">';
                            html += '<div class="card-body">';
                                html += '<div class="row align-items-center justify-content-between m-b-0">';
                                    html += '<div class="col">';
                                        html += '<h6 class="m-b-0">' + response[1][k].item + '</h6>';
                                        html += '<h3 class="m-b-0">' + response[1][k].total + '</h3>'; 
                                    html += '</div>';
                                    html += '<div class="col-auto">';
                                        html +='<h2 class="text-primary">('+response[1][k].unidad+')</h2>'
                                    html += '</div>';
                                html += '</div>';
                            html += '</div>';
                        html += '</div>';
                    html += '</div>';
                }
                html += '</div>';
                $('#conteo_'+sec).html(html);
            }
            Highcharts.chart('grafico_'+sec, {
                chart: {
                    type: 'column'
                },
                title: {
                    text: title 
                },
                subtitle: {
                    text: 'Consumo Total: ' + datos.reduce((acc, val) => acc + val, 0).toFixed(2),
                    style: {
                        color: '#000',
                        fontWeight: 'bold'
                    }
                },
                xAxis: {
                    categories: categorias,
                    title: {
                        text: fecha
                    }
                },
                yAxis: {
                    title: {
                        text: 'Totales'
                    }
                },
                series: [{
                    name: 'Total',
                    data: datos
                }],
                legend: {
                    enabled: false
                },
                plotOptions: {
                    column: {
                        colorByPoint: true
                    }
                }
            });
        },
        error: function(xhr, status, error) {
            console.error("Error al cargar los datos: ", error);
            $('#grafico_'+sec).html('<p class="text-danger">No existen registros aprobados para mostrar</p>');
        }
    });
}

function graficoMantenimiento(sec,fecha,tipoFormulario) {
    $.ajax({
        url: url_global +"/reporte_mantenimiento/"+sec+"/"+fecha+"/"+tipoFormulario,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            console.log(response);
            var categorias = [];
            var datos = [];
            for (var j in response) {
                categorias.push(response[j].item);
                datos.push(parseFloat(response[j].total));
            }
            Highcharts.chart('grafico_'+sec, {
                chart: {
                    type: 'column'
                },
                title: {
                    text: 'Consumo Total: ' + datos.reduce((acc, val) => acc + val, 0).toFixed(2),
                    style: {
                        color: '#000',
                        fontWeight: 'bold'
                    }
                },
                xAxis: {
                    categories: categorias,
                    title: {
                        text: fecha
                    }
                },
                yAxis: {
                    title: {
                        text: 'Totales'
                    }
                },
                series: [{
                    name: 'Total',
                    data: datos
                }],
                legend: {
                    enabled: false
                },
                plotOptions: {
                    column: {
                        colorByPoint: true
                    }
                }
            });
        },
        error: function(xhr, status, error) {
            console.error("Error al cargar los datos: ", error);
            $('#grafico_'+sec).html('<p class="text-danger">No existen registros aprobados para mostrar</p>');
        }
    });
}