var adminUrl=url_global;
var _modal_estado = $('#estadoTipoFormularioModal');
var csrf = $('input[name="_token"]').val();
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

$('table').on('click', '.btnPublicar', function ()
{ 
    _modal_estado.modal('show')
    var id = $(this).data('id');
    var estado = $(this).data('estado');
    var fecha_inicio = $(this).parent().parent().find('td').eq(5).text();
    var fecha_finalizacion = $(this).parent().parent().find('td').eq(6).text();
    $('input[name="idFormulario"]').val(id);

    if (fecha_inicio) {
        // Parsea la fecha en formato DD/MM/YYYY HH:mm
        var partes = fecha_inicio.split(' ');
        var fechaParte = partes[0].split('/');
        var horaParte = partes[1];
        
        // Reordena al formato YYYY-MM-DDThh:mm
        var fechaFormateada = fechaParte[2] + '-' + 
                            (fechaParte[1].length === 1 ? '0' + fechaParte[1] : fechaParte[1]) + '-' + 
                            (fechaParte[0].length === 1 ? '0' + fechaParte[0] : fechaParte[0]) + 
                            'T' + horaParte;
        // Asigna al input
        $('input[name="fecha_inicio"]').val(fechaFormateada);
    }
    if (fecha_finalizacion) {
        // Parsea la fecha en formato DD/MM/YYYY HH:mm
        var partes = fecha_finalizacion.split(' ');
        var fechaParte = partes[0].split('/');
        var horaParte = partes[1];
        
        // Reordena al formato YYYY-MM-DDThh:mm
        var fechaFin = fechaParte[2] + '-' + 
                            (fechaParte[1].length === 1 ? '0' + fechaParte[1] : fechaParte[1]) + '-' + 
                            (fechaParte[0].length === 1 ? '0' + fechaParte[0] : fechaParte[0]) + 
                            'T' + horaParte;
        // Asigna al input
        $('input[name="fecha_fin"]').val(fechaFin);
    }
    $('select[name="estadoFormulario"]').val(String(estado));
});

function getInputs() 
{
    var formData = new FormData();
    var id = $('input[name="idFormulario"]').val();
    var fecha_inicio = $('input[name="fecha_inicio"]').val();
    var fecha_fin = $('input[name="fecha_fin"]').val();
    var estado_formulario = $('select[name="estadoFormulario"]').val();
   
    formData.append('estado', estado_formulario);
    formData.append('id', id);
    formData.append('fecha_inicio', fecha_inicio);
    formData.append('fecha_fin', fecha_fin);

    return formData;
};

$(document).on('submit', '#storeEstadoTipoFormulario', function(event) {
	event.preventDefault();
    var e = $('select[name="estado"]').val();
    Swal.fire({
        target: document.getElementById('estadoTipoFormularioModal'),
        title: 'Desea continuar?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'SI',
        cancelButtonText:'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'POST',
                url: adminUrl + '/admin/cambiar_estado_formulario',
                data: getInputs(),
                dataType: 'JSON',
                processData: false,  // Evita que jQuery procese los datos
                contentType: false,   // Evita que jQuery establezca el tipo de contenido por defecto
                success: function ()
                { 
                    reset()
                    _modal_estado.modal('hide')
                    location.reload();
                    if(e=='true'){
                        Swal.fire('Tipo de Formulario PUBLICADO Correctamente!', '', 'success')
                    }
                    else{
                        Swal.fire('Tipo de Formulario NO PUBLICADO Correctamente!', '', 'success')
                    }
                },
                error: function (data) {
                    if (data.status === 422) {
                        // Captura los errores de validación
                        var errors = data.responseJSON.errors;

                        var errorList = '<ul>';
                        $.each(errors, function(key, value) {
                            errorList += '<li>' + value[0] + '</li>';
                        });
                        errorList += '</ul>';

                        // Muestra los errores en un modal de alerta
                        Swal.fire({
                            target: document.getElementById('estadoTipoFormularioModal'),
                            title: 'Errores de validación',
                            html: errorList,
                            icon: 'error',
                        });
                        $("$")
                    } else {
                        // Otro tipo de error
                        Swal.fire({
                            target: document.getElementById('estadoTipoFormularioModal'),
                            title: 'Hubo un error al procesar su petición',
                            text: 'Comuníquese con el administrador, ¡Gracias!',
                            icon: 'error',
                        });
                    }
                }
            })
        }
    })
});

