
var adminUrl=url_global;
var _modal = $('#unidadMedidaModal');
var btnSave = $('.btnSave');
var btnUpdate = $('.btnUpdate');
var csrf = $('input[name="_token"]').val();
$.ajaxSetup({
    headers: {'X-CSRF-Token': csrf}
});

function getRecords() {
    $.getJSON(adminUrl + '/listar_unidades', function (json) {
        var data = json.map(function (fila) {
            cadena_eliminar='<a href="javascript:void(0)" type="button" class="btnDelete text-danger m-1" data-id="' + fila.idpar_unidadmedida + '" data-name="'+fila.nombre+'" title="Eliminar unidad"><i class="fa fa-trash"></i></a>';
            cadena_editar='<a href="javascript:void(0)" type="button" class="btnEdit m-1" data-id="' + fila.idpar_unidadmedida + '"  title="Modificar datos unidad" ><i class="fa fa-edit"></i></a>';
        return $.extend({ boton: cadena_editar+cadena_eliminar}, fila);
    });
    $('#datos').DataTable( {
            destroy:true,
            "language": {
                "processing": "Procesando...",
                "lengthMenu": 'Filtrar <select>'+
                    '<option value="10">10</option>'+
                    '<option value="20">20</option>'+
                    '<option value="30">30</option>'+
                    '<option value="40">40</option>'+
                    '<option value="50">50</option>'+
                    '<option value="-1">Todos</option>'+
                    '</select> Registros',
                "paginate": {
                    "previous": '<i class="fa fa-angle-left"></i>',
                    "next": '<i class="fa fa-angle-right"></i>'
                },
                "info": "Pagina _PAGE_ de _PAGES_",
                "search": "Busqueda Gral.:",
                "emptyTable": "No existen datos registrados.",
                "infoEmpty": "",
            },
            ordering: false,
            pageLength: 10,
            paging: true,
            searching: true,
            info: false,
            data: data,
            columns: [
                {  data: "boton",class:'text-center' },
                {  data: "nombre" },
                {  data: "simbolo" },
            ]
        } );
    });
};

getRecords();

function reset() 
{
    _modal.find('input').each(function () 
    {
        $(this).val(null)
    })
};


function getInputs() 
{
    var id = $('input[name="id"]').val();
    var nombre = $('input[name="nombre"]').val();
    var simbolo = $('input[name="simbolo"]').val();
    return {id: id, nombre: nombre, simbolo: simbolo};
};

_modal.on('shown.bs.modal', function () {
    $('#nombre').trigger('focus')
  })

function create() 
{ 
    _modal.find('.modal-title').text('Nueva Unidad Medida');
    reset();
    _modal.modal('show')
    btnSave.show()
    btnUpdate.hide()
}


$(document).on('submit', '#storeUnidadMedida', function(event) {
	event.preventDefault();
    var id = $('#id').val();
    Swal.fire({
        target: document.getElementById('unidadMedidaModal'),
        title: 'Desea continuar?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'SI',
        cancelButtonText:'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'POST',
                url: adminUrl + '/unidad_medida/store',
                data: getInputs(),
                dataType: 'JSON',
                success: function ()
                { 
                    reset()
                    _modal.modal('hide')
                    getRecords();
                    if(id!=''){
                        Swal.fire('Actualizado Correctamente!', '', 'success')
                    }
                    else{
                        Swal.fire('Registrado Correctamente!', '', 'success')
                    }
                },
                error: function (data) {
                    if (data.status === 422) {
                        // Captura los errores de validación
                        var errors = data.responseJSON.errors;

                        var errorList = '<ul>';
                        $.each(errors, function(key, value) {
                            errorList += '<li>' + value[0] + '</li>';
                        });
                        errorList += '</ul>';

                        // Muestra los errores en un modal de alerta
                        Swal.fire({
                            target: document.getElementById('unidadMedidaModal'),
                            title: 'Errores de validación',
                            html: errorList,
                            icon: 'error',
                        });
                        $("$")
                    } else {
                        // Otro tipo de error
                        Swal.fire(
                            
                            'Hubo un error al procesar su petición',
                            'Comuníquese con el administrador, ¡Gracias!',
                            'error'
                        );
                    }
                }
            })
        }
      
    })
});


$('table').on('click', '.btnEdit', function ()
{ 
    _modal.find('.modal-title').text('Modificar Unidad de Medida')
    _modal.modal('show')

    btnSave.hide()
    btnUpdate.show()

    var id = $(this).data('id');
    var nombre_unidad = $(this).parent().parent().find('td').eq(1).text()
    var simbolo_unidad = $(this).parent().parent().find('td').eq(2).text()
    $('input[name="id"]').val(id);
    $('input[name="nombre"]').val(nombre_unidad);
    $('input[name="simbolo"]').val(simbolo_unidad);
});


$('table').on('click', '.btnDelete', function () 
{
    var id = $(this).data('id');
    var nombre = $(this).data('name');

    Swal.fire({
        title: '¿Está seguro?',
        text: 'Se eliminara la unidad de medida '+nombre+' del formulario en el que se encuentre.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'DELETE',
                url: adminUrl + '/unidad_medida/'+id+'/destroy',
                dataType: 'JSON',
                success: function (){ 
                    getRecords();
                    Swal.fire(
                        'Eliminado!',
                        'La unidad de medida fue eliminada correctamente.',
                        'success'
                    )
                }
            })
        }
    });   
});