var adminUrl=url_global;
var _modal = $('#itemModal');
var btnSave = $('.btnSave');
var btnUpdate = $('.btnUpdate');
var csrf = $('input[name="_token"]').val();
$.ajaxSetup({
    headers: {'X-CSRF-Token': csrf}
});

function getRecords() {
    $.getJSON(adminUrl + '/listar_items', function (json) {
        var data = json.map(function (fila) {
            cadena_eliminar='<a href="javascript:void(0)" type="button" class="btnDelete text-danger m-1" data-id="' + fila.idpar_item + '" data-name="'+fila.nombre+'" title="Eliminar campo"><i class="fa fa-trash"></i></a>';
            cadena_editar='<a href="javascript:void(0)" type="button" class="btnEdit m-1" data-id="' + fila.idpar_item + '"  title="Modificar datos del campo" ><i class="fa fa-edit"></i></a>';
        return $.extend({ boton: cadena_editar+cadena_eliminar}, fila);
    });
    $('#datos').DataTable( {
            processing: true, // Activa el indicador de procesamiento
            destroy:true,
            "language": {
                "processing": "Procesando...",
                "lengthMenu": 'Filtrar <select>'+
                    '<option value="10">10</option>'+
                    '<option value="20">20</option>'+
                    '<option value="30">30</option>'+
                    '<option value="40">40</option>'+
                    '<option value="50">50</option>'+
                    '<option value="-1">Todos</option>'+
                    '</select> Registros',
                "paginate": {
                    "previous": '<i class="fa fa-angle-left"></i>',
                    "next": '<i class="fa fa-angle-right"></i>'
                },
                "info": "Pagina _PAGE_ de _PAGES_",
                "search": "Busqueda Gral.:",
                "emptyTable": "No existen datos registrados.",
                "infoEmpty": "",
            },
            ordering: false,
            pageLength: 20,
            paging: true,
            searching: true,
            info: false,
            data: data,
            columns: [
                {  data: "boton",class:'text-center' },
                {  data: "nombre" },
                {  
                    data: "ubicacion.seccion.nombre",
                    render: function(data, type, row) {
                        return data ? data : ""; // Mostrar vacío si no existe
                    }
                },
                {  
                    data: "ubicacion.seccion.formulario.nombre",
                    render: function(data, type, row) {
                        return data ? data : ""; // Mostrar vacío si no existe
                    }
                }
            ]
        });
    });

};

getRecords();

function reset() 
{
    _modal.find('input').each(function () 
    {
        $(this).val(null)
    })
};  


function getInputs() 
{
    var id = $('input[name="id"]').val();
    var nombre = $('input[name="nombre"]').val();
    return {id: id, nombre: nombre};
};

_modal.on('shown.bs.modal', function () {
    $('#nombre').trigger('focus')
  })


$(document).on('submit', '#storeItem', function(event) {
	event.preventDefault();
    var id = $('#id').val();
    Swal.fire({
        target: document.getElementById('itemModal'),
        title: 'Desea continuar?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'SI',
        cancelButtonText:'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'POST',
                url: adminUrl + '/items_update',
                data: getInputs(),
                dataType: 'JSON',
                success: function ()
                { 
                    reset()
                    _modal.modal('hide')
                    location.reload();
                    if(id!=''){
                        Swal.fire('Actualizado Correctamente!', '', 'success')
                    }
                    else{
                        Swal.fire('Registrado Correctamente!', '', 'success')
                    }
                },
                error: function (data) {
                    if (data.status === 422) {
                        // Captura los errores de validación
                        var errors = data.responseJSON.errors;

                        var errorList = '<ul>';
                        $.each(errors, function(key, value) {
                            errorList += '<li>' + value[0] + '</li>';
                        });
                        errorList += '</ul>';

                        // Muestra los errores en un modal de alerta
                        Swal.fire({
                            target: document.getElementById('itemModal'),
                            title: 'Errores de validación',
                            html: errorList,
                            icon: 'error',
                        });
                        $("$")
                    } else {
                        // Otro tipo de error
                        Swal.fire(
                            
                            'Hubo un error al procesar su petición',
                            'Comuníquese con el administrador, ¡Gracias!',
                            'error'
                        );
                    }
                }
            })
        }
      
    })
});


$('table').on('click', '.btnEdit', function ()
{ 
    _modal.find('.modal-title').text('Modificar Campo')
    _modal.modal('show')

    btnSave.hide()
    btnUpdate.show()

    var id = $(this).data('id');
    var nombre_campo = $(this).parent().parent().find('td').eq(1).text()
    $('input[name="idpar_item"]').val(id);
    $('input[name="nombre"]').val(nombre_campo);
});


$('table').on('click', '.btnDelete', function () 
{
    var id = $(this).data('id');
    var nombre = $(this).data('name');

    Swal.fire({
        title: '¿Está seguro?',
        text: 'Se eliminara el campo '+nombre+' de todos los formularios donde se agrego.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'DELETE',
                url: adminUrl + '/eliminar_campo/'+id,
                dataType: 'JSON',
                success: function (){ 
                    //getRecords();
                    //recargar pagina
                    location.reload();
                    Swal.fire(
                        'Eliminado!',
                        'El campo fue eliminado correctamente.',
                        'success'
                    )
                }
            })
        }
    });   
});