<?php

namespace Database\Seeders;

use App\Models\ParEmpresa;
use App\Models\ParPlanta;
use Illuminate\Database\Seeder;
use App\Models\ParTipoformulario;
use App\Models\RepFormulariocontenido;
use App\Models\RepFormularioseccion;
use App\Models\RepFormularioplanilladato;
use App\Models\RepFormularioplanillaregistro;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PlanillaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plantas = ParPlanta::all();
        $formularios = ParTipoformulario::all();

        for ($i = 0; $i < 365; $i++) {
            $fechaAleatoria = fake()->dateTimeBetween('2023-01-01', '2023-12-31');
            $empresa = 1;
            $tipoFormularioId =3; //$formularios->random()->idpar_tipoformulario; // Guardamos solo el ID del formulario
            
            // Creamos el formulario y almacenamos el resultado en una variable diferente
            $formularioDato = RepFormularioplanilladato::create([
                'idpar_planta' => $empresa,
                'idpar_tipoformulario' => $tipoFormularioId,
                'fecha_registro_formulario' => $fechaAleatoria,
                'quien_registro' => 'admin',
                'usuario_creacion' => 'admin',
                'fecha_creacion' => now(),
                'usuario_modificacion' => null,
                'fecha_modificacion' => null,
                'estado' => false,
                'eliminado' => false,
            ]);

            // Ahora usamos $tipoFormularioId (el ID original) para filtrar las secciones
            $secciones = RepFormularioseccion::where('eliminado', false)
                ->where('idpar_planta', $empresa)
                ->where('idpar_tipoformulario', $tipoFormularioId) // Aquí usamos el ID correcto
                ->get();

            foreach ($secciones as $seccion) {
                $contenido = RepFormulariocontenido::where('eliminado', false)
                    ->where('idrep_formularioseccion', $seccion->idrep_formularioseccion)
                    ->get();

                foreach ($contenido as $registro) {
                    RepFormularioplanillaregistro::create([
                        'idrep_formularioplanilladato' => $formularioDato->idrep_formularioplanilladato, // Usamos la variable correcta
                        'idrep_formulariocontenido' => $registro->idrep_formulariocontenido,
                        'valor' => fake()->randomFloat(2, 0, 1000),
                        'usuario_creacion' => 'admin',
                        'fecha_creacion' => now(),
                        'usuario_modificacion' => null,
                        'fecha_modificacion' => null,
                        'estado' => true,
                        'eliminado' => false,
                    ]);
                }
            }
        }
    }

}
