<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('par_tipoformulario', function (Blueprint $table) {
            $table->string('codigo')->nullable()->comment('Codigo sociado al tipo de formulario, se utiliza para generar el codigo de las planillas de datos.')->after('nombre');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('par_tipoformulario', function (Blueprint $table) {
            $table->dropColumn('codigo');
        });
    }
};
