<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('rep_formularioplanilladato', function (Blueprint $table) {
            $table->integer('numero_correlativo')->comment('correlativo de la planilla por gestion y tipo de formulario calculado con un trigger desde la base de datos')->nullable();
            $table->string('codigo_correlativo')->comment('codigo que se conforma con el número correlativo y la gestión')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('rep_formularioplanilladato', function (Blueprint $table) {
            $table->dropColumn(['numero_correlativo', 'codigo_correlativo']);
        });
    }
};
