<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['idsegUsuario', 'idsegPerfil', 'nombrePerfil']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->unsignedBigInteger('idsegUsuario')->nullable()->after('id');
            $table->unsignedBigInteger('idsegPerfil')->nullable()->after('idsegUsuario');
            $table->string('nombrePerfil')->nullable()->after('idsegPerfil');
        });
    }
};
