<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('usuario_creacion')->nullable();
            $table->datetime('fecha_creacion')->nullable();
            $table->string('usuario_modificacion')->nullable();
            $table->datetime('fecha_modificacion')->nullable();
            $table->string('usuario_eliminacion')->nullable();
            $table->datetime('fecha_eliminacion')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('usuario_creacion');
            $table->dropColumn('fecha_creacion');
            $table->dropColumn('usuario_modificacion');
            $table->dropColumn('fecha_modificacion');
            $table->dropColumn('usuario_eliminacion');
            $table->dropColumn('fecha_eliminacion');
        });
    }
};
