<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::unprepared("
            CREATE OR REPLACE FUNCTION generar_correlativo()
            RETURNS TRIGGER AS $$
            DECLARE
                num INTEGER;
                codigo_form varchar(255);
            BEGIN
                -- Obtener el número máximo del formulario para el año en curso y tipo de formulario
                SELECT COALESCE(MAX(numero_correlativo), 0) + 1 INTO num
                FROM rep_formularioplanilladato
                WHERE EXTRACT(YEAR FROM fecha_registro_formulario) = EXTRACT(YEAR FROM NEW.fecha_registro_formulario)
                AND idpar_tipoformulario = NEW.idpar_tipoformulario;

                -- Obtener el código del formulario
                SELECT codigo INTO codigo_form
                FROM par_tipoformulario
                WHERE idpar_tipoformulario = NEW.idpar_tipoformulario;

                -- Asignar el número generado al nuevo registro
                NEW.numero_correlativo := num;

                -- Asignar el código correlativo solo si el código del formulario no es nulo
                IF codigo_form IS NOT NULL THEN
                    NEW.codigo_correlativo := CONCAT(codigo_form, '-', num, '/', EXTRACT(YEAR FROM NEW.fecha_registro_formulario));
                END IF;

                RETURN NEW;
            END;
            $$ LANGUAGE plpgsql;
            DROP TRIGGER IF EXISTS trigger_numero_correlativo ON rep_formularioplanilladato;

            CREATE TRIGGER trigger_numero_correlativo
            BEFORE INSERT ON rep_formularioplanilladato
            FOR EACH ROW
            EXECUTE FUNCTION generar_correlativo();
        ");

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::unprepared('DROP function generar_numero_correlativo');
        DB::unprepared('DROP TRIGGER trigger_numero_correlativo');
    }
};
