<?php

use Illuminate\Support\Facades\DB;
use App\Traits\NombraPrimaryKeyTrait;
use Illuminate\Support\Facades\Schema;
use App\Traits\RenombraSecuenciasTrait;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    use RenombraSecuenciasTrait, NombraPrimaryKeyTrait;
    public function up(): void
    {
        Schema::create('rep_formularioplanillaregistro', function (Blueprint $table) {
            $table->id('idrep_formularioplanillaregistro');
            $table->unsignedBigInteger('idrep_formularioplanilladato');
            $table->unsignedBigInteger('idrep_formulariocontenido');
            $table->text('valor')->nullable()->comment('valor ingresado puede ser numero o texto depende del tipo de campo establecido para el item');
            $table->string('observacion')->nullable();
            $table->string('usuario_creacion',40);
            $table->datetime('fecha_creacion');
            $table->string('usuario_modificacion',40)->nullable();
            $table->datetime('fecha_modificacion')->nullable();
            $table->string('usuario_aprobacion',40)->nullable();
            $table->datetime('fecha_aprobacion')->nullable();
            $table->boolean('estado')->default(true);
            $table->boolean('eliminado')->default(false);
            $table->integer('nro_item')->nullable();
            $table->integer('unidad_sedem')->nullable();
            $table->foreign('idrep_formularioplanilladato','fk_formularioplanillaregistro_formularioplanilladato')->references('idrep_formularioplanilladato')->on('rep_formularioplanilladato')->onDelete('restrict')->onUpdate('restrict');
            $table->foreign('idrep_formulariocontenido','fk_formularioplanillaregistro_formulariocontenido')->references('idrep_formulariocontenido')->on('rep_formulariocontenido')->onDelete('restrict')->onUpdate('restrict');
        });

        DB::statement('DROP SEQUENCE IF EXISTS sq_rep_formularioplanillaregistro CASCADE');
         // Crear la secuencia manualmente
        DB::statement("CREATE SEQUENCE sq_rep_formularioplanillaregistro START 1 INCREMENT 1;");

         // Asociar la secuencia a la columna 'id_rep_formularioregistrosplanilla'
        DB::statement("ALTER TABLE rep_formularioplanillaregistro ALTER COLUMN idrep_formularioplanillaregistro SET DEFAULT nextval('sq_rep_formularioplanillaregistro');");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rep_formularioregistrosplanilla');
    }
};
