<?php

use Illuminate\Support\Facades\DB;
use App\Traits\NombraPrimaryKeyTrait;
use Illuminate\Support\Facades\Schema;
use App\Traits\RenombraSecuenciasTrait;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    use RenombraSecuenciasTrait, NombraPrimaryKeyTrait;

    public function up(): void
    {
        Schema::create('rep_formularioplanilladato', function (Blueprint $table) {
            $table->id('idrep_formularioplanilladato');
            $table->unsignedBigInteger('idpar_tipoformulario');
            $table->date('fecha_registro_formulario')->nullable();
            $table->string('observacion')->nullable();
            $table->string('quien_registro');
            $table->string('usuario_creacion',40);
            $table->datetime('fecha_creacion');
            $table->string('usuario_modificacion',40)->nullable();
            $table->datetime('fecha_modificacion')->nullable();
            $table->boolean('estado')->default(true);
            $table->boolean('eliminado')->default(false);
            $table->integer('unidad_sedem')->nullable();
            $table->foreign('idpar_tipoformulario','fk_formularioplanilladato_tipoformulario')->references('idpar_tipoformulario')->on('par_tipoformulario')->onDelete('restrict')->onUpdate('restrict'); 
        });

        DB::statement('DROP SEQUENCE IF EXISTS sq_rep_formularioplanilladato CASCADE');
         // Crear la secuencia manualmente
         DB::statement("CREATE SEQUENCE sq_rep_formularioplanilladato START 1 INCREMENT 1;");

         // Asociar la secuencia a la columna 'id_rep_formulariodatosplanilla'
        DB::statement("ALTER TABLE rep_formularioplanilladato ALTER COLUMN idrep_formularioplanilladato SET DEFAULT nextval('sq_rep_formularioplanilladato');");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rep_formularioplanilladato');
    }
};
