<?php
use Illuminate\Support\Facades\DB;
use App\Traits\NombraPrimaryKeyTrait;
use Illuminate\Support\Facades\Schema;
use App\Traits\RenombraSecuenciasTrait;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    use RenombraSecuenciasTrait, NombraPrimaryKeyTrait;
    public function up(): void
    {
        Schema::create('rep_formulariocontenido', function (Blueprint $table) {
            $table->id('idrep_formulariocontenido');
            $table->unsignedBigInteger('idrep_formularioseccion');
            $table->unsignedBigInteger('idpar_item');
            $table->unsignedBigInteger('idpar_itemgrupo')->nullable();
            $table->unsignedBigInteger('idpar_unidadmedida')->nullable();
            $table->integer('orden_item')->nullable()->comment('posicion de la sección dentro el formulario');
            $table->string('tipo_campo')->nullable()->commet('tipo de campo: text, number, decimal, select, bolean(radio button)');
            $table->string('items_lista')->nullable()->comment('items que se muestran en el select o radio button');
            $table->boolean('obligatorio')->nullable()->comment('indica si el valor a ingresar es obligatorio o no');
            $table->boolean('unico')->nullable()->comment('indica si el valor a ingresar es unico o no');
            $table->string('item_formula')->nullable()->comment('guarda el valor de la formula de calculo entre items asociados a un formulario');
            $table->text('valor_predeterminado')->nullable()->comment('valor que debe mostrarse por defecto al momento de ingresar un registro del formulario');
            $table->string('usuario_creacion',40);
            $table->string('usuario_modificacion',40)->nullable();
            $table->datetime('fecha_creacion');
            $table->datetime('fecha_modificacion')->nullable();
            $table->boolean('estado')->default(true);
            $table->boolean('eliminado')->default(false);
            $table->integer('unidad_sedem')->nullable();
            $table->decimal('ancho_campo',10,2)->nullable();
            $table->foreign('idpar_item', 'fk_formulariocontenido_item')->references('idpar_item')->on('par_item')->onDelete('restrict')->onUpdate('restrict');
            $table->foreign('idpar_itemgrupo', 'fk_formulariocontenido_itemgrupo')->references('idpar_item')->on('par_item')->onDelete('restrict')->onUpdate('restrict');
            $table->foreign('idrep_formularioseccion', 'fk_formulariocontenido_formularioseccion')->references('idrep_formularioseccion')->on('rep_formularioseccion')->onDelete('restrict')->onUpdate('restrict');
        });

        DB::statement('DROP SEQUENCE IF EXISTS sq_rep_formulariocontenido CASCADE');
        // Crear la secuencia manualmente
        DB::statement("CREATE SEQUENCE sq_rep_formulariocontenido START 1 INCREMENT 1;");

        // Asociar la secuencia a la columna 'id_rep_formulariocontenido'
        DB::statement("ALTER TABLE rep_formulariocontenido ALTER COLUMN idrep_formulariocontenido SET DEFAULT nextval('sq_rep_formulariocontenido');");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rep_formulariocontenido');
    }
};
