<?php

use Illuminate\Support\Facades\DB;
use App\Traits\NombraPrimaryKeyTrait;
use Illuminate\Support\Facades\Schema;
use App\Traits\RenombraSecuenciasTrait;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    use RenombraSecuenciasTrait, NombraPrimaryKeyTrait;
    public function up(): void
    {
        Schema::create('par_item', function (Blueprint $table) {
            $table->id('idpar_item');
            $table->string('nombre');
            $table->string('usuario_creacion',40);
            $table->datetime('fecha_creacion');
            $table->string('usuario_modificacion',40)->nullable();
            $table->datetime('fecha_modificacion')->nullable();
            $table->boolean('estado')->default(true);
            $table->boolean('eliminado')->default(false);
            $table->integer('unidad_sedem')->nullable();
        });
        
        DB::statement('DROP SEQUENCE IF EXISTS sq_par_item CASCADE');
        // Renombrar la secuencia generada automáticamente
        DB::statement("CREATE SEQUENCE sq_par_item START 1 INCREMENT 1;");

        // Asociar la secuencia a la columna 'idpar_item'
        DB::statement("ALTER TABLE par_item ALTER COLUMN idpar_item SET DEFAULT nextval('sq_par_item');");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('par_item');
       
    }
};
