<?php

use Illuminate\Support\Facades\DB;
use App\Traits\NombraPrimaryKeyTrait;
use Illuminate\Support\Facades\Schema;
use App\Traits\RenombraSecuenciasTrait;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    use RenombraSecuenciasTrait, NombraPrimaryKeyTrait;
    /**
     * Run the migrations.
     */
    public function up(): void
    {   
        Schema::create('rep_formularioseccion', function (Blueprint $table) {
            $table->id('idrep_formularioseccion');
            $table->unsignedBigInteger('idpar_tipoformulario');
            $table->string('nombre');
            $table->string('tipo')->nullable()->comment('el valor puede ser general o tabla');
            $table->integer('orden')->nullable()->comment('posicion de la sección dentro el formulario');
            $table->string('usuario_creacion',40);
            $table->datetime('fecha_creacion');
            $table->string('usuario_modificacion',40)->nullable();
            $table->datetime('fecha_modificacion')->nullable();
            $table->boolean('estado')->default(true);
            $table->boolean('eliminado')->default(false);
            $table->integer('unidad_sedem')->nullable();
            $table->foreign('idpar_tipoformulario','fk_formularioseccion_tipoformulario')->references('idpar_tipoformulario')->on('par_tipoformulario')->onDelete('restrict')->onUpdate('restrict');
        });

        DB::statement('DROP SEQUENCE IF EXISTS sq_rep_formularioseccion CASCADE');
         // Crear la secuencia manualmente
         DB::statement("CREATE SEQUENCE sq_rep_formularioseccion START 1 INCREMENT 1;");

         // Asociar la secuencia a la columna 'id_par_formularioseccion'
         DB::statement("ALTER TABLE rep_formularioseccion ALTER COLUMN idrep_formularioseccion SET DEFAULT nextval('sq_rep_formularioseccion');");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rep_formularioseccion');    
    }
};
