<?php

use Illuminate\Support\Facades\DB;
use App\Traits\NombraPrimaryKeyTrait;
use Illuminate\Support\Facades\Schema;
use App\Traits\RenombraSecuenciasTrait;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    use RenombraSecuenciasTrait, NombraPrimaryKeyTrait;
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('par_unidadmedida', function (Blueprint $table) {
            $table->id('idpar_unidadmedida');
            $table->string('nombre');
            $table->string('simbolo');
            $table->string('usuario_creacion',40);
            $table->datetime('fecha_creacion');
            $table->string('usuario_modificacion',40)->nullable();
            $table->datetime('fecha_modificacion')->nullable();
            $table->boolean('estado')->default(true);
            $table->boolean('eliminado')->default(false);
            $table->integer('unidad_sedem')->nullable();
        });

        DB::statement('DROP SEQUENCE IF EXISTS sq_par_unidadmedida CASCADE');
         // Crear la secuencia manualmente
         DB::statement("CREATE SEQUENCE sq_par_unidadmedida START 1 INCREMENT 1;");

         // Asociar la secuencia a la columna 'id_par_unidadmedida'
         DB::statement("ALTER TABLE par_unidadmedida ALTER COLUMN idpar_unidadmedida SET DEFAULT nextval('sq_par_unidadmedida');");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('par_unidadmedida');
    }
};
