<?php

use Illuminate\Support\Facades\DB;
use App\Traits\NombraPrimaryKeyTrait;
use Illuminate\Support\Facades\Schema;
use App\Traits\RenombraSecuenciasTrait;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    use RenombraSecuenciasTrait, NombraPrimaryKeyTrait;
    public function up(): void
    {
        Schema::create('par_tipoformulario', function (Blueprint $table) {
            $table->id('idpar_tipoformulario');
            $table->string('nombre');
            $table->string('logo');
            $table->string('descripcion')->nullable();
            $table->string('usuario_creacion',40);
            $table->datetime('fecha_creacion');
            $table->string('usuario_modificacion',40)->nullable();
            $table->datetime('fecha_modificacion')->nullable();
            $table->string('usuario_eliminacion',40)->nullable();
            $table->datetime('fecha_eliminacion')->nullable();
            $table->boolean('estado')->default(false)->comment('0: No publicado, 1: Publicado');
            $table->boolean('eliminado')->default(false);
        });

        DB::statement('DROP SEQUENCE IF EXISTS sq_par_tipoformulario CASCADE');
        // Crear la secuencia manualmente
        DB::statement("CREATE SEQUENCE sq_par_tipoformulario START 1 INCREMENT 1;");

        // Asociar la secuencia a la columna 'id_rep_formulario'
        DB::statement("ALTER TABLE par_tipoformulario ALTER COLUMN idpar_tipoformulario SET DEFAULT nextval('sq_par_tipoformulario');");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('par_tipoformulario');
    }
};
