<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('par_empresa', function (Blueprint $table) {
            $table->id('idpar_empresa');
            $table->string('nombre',200);
            $table->string('sigla',100);
            $table->string('logo');
            $table->string('color');
            $table->string('usuario_creacion',40);
            $table->datetime('fecha_creacion');
            $table->string('usuario_modificacion',40)->nullable();
            $table->datetime('fecha_modificacion')->nullable();
            $table->boolean('estado')->default(true);
            $table->boolean('eliminado')->default(false);
        });

        DB::statement('DROP SEQUENCE IF EXISTS sq_par_empresa CASCADE');
        // Crear la secuencia manualmente
        DB::statement("CREATE SEQUENCE sq_par_empresa START 1 INCREMENT 1;");

        // Asociar la secuencia a la columna 'idpar_empresa'
        DB::statement("ALTER TABLE par_empresa ALTER COLUMN idpar_empresa SET DEFAULT nextval('sq_par_empresa');");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('par_empresa');
    }
};
