<?php

return [
    'disable' => env('CAPTCHA_DISABLE', false),
    'characters' => ['2', '3', '4', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'm', 'n', 'p', 'q', 'r', 't', 'u', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'M', 'N', 'P', 'Q', 'R', 'T', 'U', 'X', 'Y', 'Z'],
    'default' => [
        'length' => 5,
        'width' => 200,
        'height' => 66,
        'quality' => 90,
        'math' => false,
        'expire' => 60,
        'encrypt' => false,
    ],
    'large' => [
        'length' => 6,                 // Reducir a 4 caracteres para mayor claridad
        'width' => 200,                // Aumentar el ancho
        'height' => 50,                // Aumentar la altura
        'quality' => 100,              // Calidad m�xima
        'lines' => 2,                  // Reducir el n�mero de l�neas que pueden interferir
        'bgImage' => false,            // Sin imagen de fondo
        'bgColor' => '#ffffff',        // Fondo blanco
        'fontColors' => ['#2c3e50', '#2980b9', '#000000', '#4E1F00', '#0118D8'], // Colores m�s oscuros y contrastantes
        'contrast' => 0,   
        // 'fonts' => ['/usr/share/fonts/truetype/freefont/FreeSansBold.ttf'],
        'fonts' => [
            public_path('/fonts/Roboto-Bold.ttf'),
        ],
        // 'fonts' => ['C:\\Windows\\Fonts\\arial.ttf', 'C:\\Windows\\Fonts\\verdana.ttf'],
        'fontSize' => 22,              // Aumentar tama�o de fuente
        'angle' => 0,                  // Sin rotaci�n para evitar confusiones
        'characters' => '23456789ABCDEFGHJKLMNPQRSTUVWXYZ', // Excluir caracteres confusos
        'sharpen' => 10,               // Agregar un poco de nitidez
        'blur' => false,               // Sin desenfoque
        'invert' => false,    
    ],
    'math' => [
        'length' => 9,
        'width' => 120,
        'height' => 36,
        'quality' => 90,
        'math' => true,
    ],

    'flat' => [
        'length' => 6,
        'width' => 160,
        'height' => 46,
        'quality' => 90,
        'lines' => 6,
        'bgImage' => false,
        'bgColor' => '#ecf2f4',
        'fontColors' => ['#2c3e50', '#c0392b', '#16a085', '#c0392b', '#8e44ad', '#303f9f', '#f57c00', '#795548'],
        'contrast' => -5,
    ],
    'mini' => [
        'length' => 3,
        'width' => 60,
        'height' => 32,
    ],
    'inverse' => [
        'length' => 5,
        'width' => 120,
        'height' => 36,
        'quality' => 90,
        'sensitive' => true,
        'angle' => 12,
        'sharpen' => 10,
        'blur' => 2,
        'invert' => true,
        'contrast' => -5,
    ]
];
