<?php

namespace App\Traits;

use Illuminate\Support\Facades\DB;

trait RenombraSecuenciasTrait
{
    /**
     * Renombra la secuencia de una tabla PostgreSQL.
     *
     * @param string $tabla Nombre de la tabla.
     * @param string $columna Nombre de la columna con la secuencia.
     */
    public function renombrarSecuencia(string $tabla, string $columna = 'id')
    {
        $secuenciaActual = "{$tabla}_{$columna}_seq";
        $nuevaSecuencia = "sq_{$tabla}";

        DB::statement("ALTER SEQUENCE {$secuenciaActual} RENAME TO {$nuevaSecuencia}");
    }
}
