<?php
namespace App\Traits;

use Illuminate\Support\Facades\DB;

trait NombraPrimaryKeyTrait
{
    /**
     * Agrega un constraint de llave primaria con nombre personalizado.
     *
     * @param string $tabla Nombre de la tabla.
     * @param string $columna Nombre de la columna clave primaria.
     */
    public function agregarPrimaryKey(string $tabla, string $columna = 'id')
    {
        $nombreConstraint = "pk_{$columna}";
        DB::statement("ALTER TABLE {$tabla} ADD CONSTRAINT {$nombreConstraint} PRIMARY KEY ({$columna})");
    }
}
