<?php

namespace App\Providers;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\ServiceProvider;

class ExternalAuthProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
    public function loginWithExternalService(Request $request)
    {
        // Obtener los valores de username y password del formulario
        $username = $request->input('username');
        $password = $request->input('password');

        // Realiza la solicitud HTTP al servicio externo (API)
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',  // Asegúrate de enviar como JSON
        ])->post('http://192.168.10.57:6062/api/Identity/autenticate', [
            'userName' => $username,
            'password' => $password,
        ]);

        // Verificar si la respuesta es exitosa
        if ($response->successful()) {
            $userData = $response->json();  // Obtener los datos del usuario (por ejemplo: nombre, correo, etc.)

            // Crear un usuario "virtual" o "anónimo" para autenticar en Laravel
            $user = new \App\Models\User();  // Puedes usar una clase "dummy" si no quieres que se almacenen en la DB
            $user->name = $userData['name'];
            $user->email = $userData['email'];
            $user->username = $userData['username'];

            // Opcional: Asignar un ID ficticio, ya que Laravel generalmente requiere un ID
            $user->setAttribute('id', $userData['id'] ?? null);  // Usar algún identificador, si es necesario

            // Autenticar al usuario
            Auth::login($user);

            // Redirigir a la página de inicio
            return redirect()->route('home');
        }

        // Si las credenciales no son válidas, mostrar un mensaje de error
        return back()->withErrors(['login' => 'Credenciales incorrectas.']);
    }
}
