<?php

namespace App\Providers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\URL;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
       //Forzar HTTPS en todos los entornos
        URL::forceScheme('https');
        
        // O alternativamente, solo en producci?n
        if ($this->app->environment('production')) {
            URL::forceScheme('https');
        }
        
        // O para varios entornos espec?ficos
        if (in_array($this->app->environment(), ['production', 'staging'])) {
            URL::forceScheme('https');
        }
        
    }
}
