<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Notifications\Notifiable;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory,SoftDeletes;
    use HasRoles,HasApiTokens, HasFactory, Notifiable;
    protected $guard_name = 'web';
    protected $connection = 'pgsql'; // Establecer la conexión para este modelo
    public $timestamps = false;
    
    const CREATED_AT = 'fecha_creacion';
    const UPDATED_AT = 'fecha_modificacion';
    const DELETED_AT = 'fecha_eliminacion';

    protected $dates = ['fecha_eliminacion','usuario_eliminacion'];
    
    protected $fillable = [
        'name',
        'username',
        'email',
        'ci',
        'cargo',
        'unidad_rrhh',
        'avatar',
        'password','usuario_creacion',
        'fecha_creacion',
        'usuario_modificacion',
        'fecha_modificacion','usuario_eliminacion',
        'fecha_eliminacion',
    ];
   
    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    //excluir o incluir los campos que deseas auditar
    protected $auditInclude = [
        'usuario_creacion', 'fecha_creacion',
        'usuario_modificacion', 'fecha_modificacion',
        'usuario_eliminacion', 'fecha_eliminacion',
        'name', 'username', 'email','ci','cargo','unidad_rrhh','avatar','roles','password'
    ];

    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (auth()->check() && empty($model->usuario_creacion)) {
                $model->usuario_creacion = auth()->user()->name;
                $model->fecha_creacion = now();
            }
        });

        static::updating(function ($model) {
            // No sobrescribir estos campos si ya están establecidos
            if (auth()->check() && $model->isDirty() && !$model->isDirty(['usuario_eliminacion', 'fecha_eliminacion'])) {
                $model->usuario_modificacion = auth()->user()->name;
                $model->fecha_modificacion = now();
            }
        });
    }

    public function delete()
    {
        if (auth()->check()) {
            $this->usuario_eliminacion = auth()->user()->name;
            $this->fecha_eliminacion = now();
            $this->save();
        }
        
        return parent::delete();
    }
    
    public function before(User $user, string $ability): ?bool
    {
        if ($user->hasRole('superadmin')) {
            return true;
        }
    
        return null; // see the note above in Gate::before about why null must be returned here.
    }
    public function rol()
    {
        return $this->belongsToMany('Spatie\Permission\Models\Role', 'model_has_roles', 'model_id', 'role_id')->withPivot('role_id');
    }

}
