<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RepFormularioplanillaregistro extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory,SoftDeletes;

    protected $table = 'rep_formularioplanillaregistro';
    protected $primaryKey = 'idrep_formularioplanillaregistro';

    public $timestamps = true;
    
    const CREATED_AT = 'fecha_creacion';
    const UPDATED_AT = 'fecha_modificacion';
    const DELETED_AT = 'fecha_eliminacion';

    const CREATED_BY = 'usuario_creacion';
    const UPDATED_BY = 'usuario_modificacion';
    const DELETED_BY = 'usuario_eliminacion';

    //excluir o incluir los campos que deseas auditar
    protected $auditInclude = [
        'usuario_creacion', 'fecha_creacion',
        'usuario_modificacion', 'fecha_modificacion',
        'usuario_eliminacion', 'fecha_eliminacion','idrep_formularioplanillaregistro',
        'idrep_formularioplanilladato','idrep_formulariocontenido','valor','observacion','usuario_aprobacion','fecha_aprobacion','estado','eliminado','nro_item'
    ];

    public static function boot()
    {
        parent::boot();
        
        // Ahora solo necesitamos manejar los campos de usuario
        static::creating(function ($model) {
            $model->{self::CREATED_BY} = auth()->check() ? auth()->user()->name : null;
            // No necesitamos establecer CREATED_AT, Laravel lo hace automáticamente
        });
        
        static::updating(function ($model) {
            $model->{self::UPDATED_BY} = auth()->check() ? auth()->user()->name : null;
            // No necesitamos establecer UPDATED_AT, Laravel lo hace automáticamente
        });
        
        // Para la eliminación suave
        static::deleting(function ($model) {
            if (!$model->isForceDeleting()) {
                $model->{self::DELETED_BY} = auth()->check() ? auth()->user()->name : null;
                $model->eliminado = true;
                $model->save(); // Guardamos para que se apliquen estos cambios
                // DELETED_AT será manejado automáticamente por SoftDeletes
            }
        });
    }

    public function item(){
        return $this->belongsTo(ParItem::class,'id_item');
    }

    public function seccion(){
        return $this->belongsTo(RepFormularioseccion::class,'idrep_formularioseccion');
    }
}
