<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RepFormularioplanilladato extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory,SoftDeletes;

    protected $table = 'rep_formularioplanilladato';

    protected $primaryKey = 'idrep_formularioplanilladato';

    public $timestamps = true;

    const CREATED_AT = 'fecha_creacion';
    const UPDATED_AT = 'fecha_modificacion';
    const DELETED_AT = 'fecha_eliminacion'; 

    const CREATED_BY = 'usuario_creacion';
    const UPDATED_BY = 'usuario_modificacion';
    const DELETED_BY = 'usuario_eliminacion';

    //excluir o incluir los campos que deseas auditar
    protected $auditInclude = [
        'usuario_creacion', 'fecha_creacion',
        'usuario_modificacion', 'fecha_modificacion',
        'usuario_eliminacion', 'fecha_eliminacion',
        'idpar_tipoformulario', 'fecha_registro_formulario', 'observacion', 'quien_registro', 'estado',
        'eliminado'
    ];

    public static function boot()
    {
        parent::boot();
        
        // Ahora solo necesitamos manejar los campos de usuario
        static::creating(function ($model) {
            $model->{self::CREATED_BY} = auth()->check() ? auth()->user()->name : null;
            // No necesitamos establecer CREATED_AT, Laravel lo hace automáticamente
        });
        
        static::updating(function ($model) {
            $model->{self::UPDATED_BY} = auth()->check() ? auth()->user()->name : null;
            // No necesitamos establecer UPDATED_AT, Laravel lo hace automáticamente
        });
        
        // Para la eliminación suave
        static::deleting(function ($model) {
            if (!$model->isForceDeleting()) {
                $model->{self::DELETED_BY} = auth()->check() ? auth()->user()->name : null;
                $model->eliminado = true;
                $model->save(); // Guardamos para que se apliquen estos cambios
                // DELETED_AT será manejado automáticamente por SoftDeletes
            }
        });
    }

    public function delete()
    {
        // Actualizamos los registros relacionados si no es una eliminación forzada
        if (!$this->isForceDeleting()) {
            $usuarioActual = auth()->check() ? auth()->user()->name : null;
            $fechaActual = now();
            
            DB::table('rep_formularioplanillaregistro')
                ->where('idrep_formulariocontenido', $this->idrep_formulariocontenido)
                ->whereNull(self::DELETED_AT)
                ->update([
                    self::DELETED_BY => $usuarioActual,
                    self::DELETED_AT => $fechaActual,
                    'eliminado' => true
                ]);
        }
        
        return parent::delete();
    }

    public function formulario(){
        return $this->belongsTo(ParTipoformulario::class, 'idpar_tipoformulario');
    }

    public function registros(){
        return $this->hasMany(RepFormularioplanillaregistro::class, 'idrep_formularioplanilladato');
    }
}
