<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RepFormulariocontenido extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory,SoftDeletes;
    
    protected $table = 'rep_formulariocontenido';
    protected $primaryKey = 'idrep_formulariocontenido';

    public $timestamps = true;

    const CREATED_AT = 'fecha_creacion';
    const UPDATED_AT = 'fecha_modificacion';
    const DELETED_AT = 'fecha_eliminacion';

    const CREATED_BY = 'usuario_creacion';
    const UPDATED_BY = 'usuario_modificacion';
    const DELETED_BY = 'usuario_eliminacion';
    //excluir o incluir los campos que deseas auditar
    protected $auditInclude = [
        'usuario_creacion', 'fecha_creacion',
        'usuario_modificacion', 'fecha_modificacion',
        'usuario_eliminacion', 'fecha_eliminacion',
        'idrep_formularioseccion', 'idpar_item', 'idpar_itemgrupo', 'idpar_unidadmedida','orden_item','tipo_campo','items_lista','obligatorio','unico','item_formula','valor_predeterminado','ancho_campo',
        'estado','eliminado',
    ];

    public static function boot()
    {
        parent::boot();
        
        // Ahora solo necesitamos manejar los campos de usuario
        static::creating(function ($model) {
            $model->{self::CREATED_BY} = auth()->check() ? auth()->user()->name : null;
            // No necesitamos establecer CREATED_AT, Laravel lo hace automáticamente
        });
        
        static::updating(function ($model) {
            $model->{self::UPDATED_BY} = auth()->check() ? auth()->user()->name : null;
            // No necesitamos establecer UPDATED_AT, Laravel lo hace automáticamente
        });
        
        // Para la eliminación suave
        static::deleting(function ($model) {
            if (!$model->isForceDeleting()) {
                $model->{self::DELETED_BY} = auth()->check() ? auth()->user()->name : null;
                $model->eliminado = true;
                $model->save(); // Guardamos para que se apliquen estos cambios
                // DELETED_AT será manejado automáticamente por SoftDeletes
            }
        });
    }

    public function delete()
    {
        // Actualizamos los registros relacionados si no es una eliminación forzada
        if (!$this->isForceDeleting()) {
            $usuarioActual = auth()->check() ? auth()->user()->name : null;
            $fechaActual = now();
            
            // Actualizar planillas
            DB::table('par_item')
                ->where('idrep_formulariocontenido', $this->idrep_formulariocontenido)
                ->whereNull(self::DELETED_AT)
                ->update([
                    self::DELETED_BY => $usuarioActual,
                    self::DELETED_AT => $fechaActual,
                    'eliminado' => true
                ]);
            
            // Actualizar secciones
            DB::table('rep_formularioplanillaregistro')
                ->where('idrep_formulariocontenido', $this->idrep_formulariocontenido)
                ->whereNull(self::DELETED_AT)
                ->update([
                    self::DELETED_BY => $usuarioActual,
                    self::DELETED_AT => $fechaActual,
                    'eliminado' => true
                ]);
        }
        
        return parent::delete();
    }

    public function seccion(){
        return $this->belongsTo(RepFormularioseccion::class,'idrep_formularioseccion');
    }    

    public function item(){
        return $this->belongsTo(ParItem::class,'idpar_item');
    }

    public function registros(){
        return $this->hasMany(RepFormularioplanillaregistro::class,'idrep_formulariocontenido');
    }

    public function grupo(){
        return $this->belongsTo(ParItem::class,'idpar_itemgrupo');
    }
    public function unidad_medida(){
        return $this->belongsTo(ParUnidadmedida::class,'idpar_unidadmedida');
    }

}
